% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker_registry.R
\docType{class}
\name{docker_registry}
\alias{docker_registry}
\title{Docker registry class}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
docker_registry
}
\description{
Class representing a \href{https://docs.docker.com/registry/}{Docker registry}. Note that this class can be used to interface with any Docker registry that supports the HTTP V2 API, not just those created via the Azure Container Registry service.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{new(...)}: Initialize a new registry object. See 'Details'.
\item \code{login}: Login to the registry via \code{docker login}.
\item \code{push(src_image, dest_image)}: Push an image to the registry, using \code{docker tag} and \code{docker push}.
\item \code{pull(image)}: Pulls an image from the registry, using \code{docker pull}.
\item \code{delete_layer(layer, digest, confirm=TRUE)}: Deletes a layer from the registry.
\item \code{delete_image(image, digest, confirm=TRUE)}: Deletes an image from the registry.
\item \code{list_repositories}: Lists the repositories (images) in the registry.
}
}

\section{Details}{

The arguments to the \code{new()} method are:
\itemize{
\item \code{server}: The name of the registry server.
\item \code{username}: The username that Docker will use to authenticate with the registry.
\item \code{password}: The password that Docker will use to authenticate with the registry.
\item \code{login}: Whether to login to the registry immediately; defaults to TRUE.
}

Currently this class does not support authentication methods other than a username/password combination.

The \code{login()}, \code{push()} and \code{pull()} methods for this class call the \code{docker} commandline tool under the hood. This allows all the features supported by Docker to be available immediately, with a minimum of effort. Any calls to the \code{docker} tool will also contain the full commandline as the \code{cmdline} attribute of the (invisible) returned value; this allows scripts to be developed that can be run outside R.
}

\examples{
\dontrun{

# recommended way of retrieving a registry: via a resource group object
rg <- AzureRMR::az_rm$
    new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# get the registry endpoint
dockerreg <- rg$get_acr("myregistry")$get_docker_registry()

dockerreg$login()
dockerreg$list_repositories()

# create an image from a Dockerfile in the current directory
call_docker("build -t myimage .")

# push the image
dockerreg$push("myimage")

}
}
\seealso{
\link{acr}, \link{call_docker}

\href{https://docs.docker.com/engine/reference/commandline/cli/}{Docker commandline reference}

\href{https://docs.docker.com/registry/spec/api/}{Docker registry API}
}
\keyword{datasets}
