% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/publish.R
\name{publishWebService}
\alias{publishWebService}
\title{Publish a function to Microsoft Azure}
\usage{
publishWebService(functionName, serviceName, inputSchema, outputSchema, wkID,
  authToken)
}
\arguments{
\item{functionName}{function name as a string to be published}

\item{serviceName}{name of the new web service}

\item{inputSchema}{list of input parameters of format \code{list("arg1"="type", "arg2"="type", ...)}}

\item{outputSchema}{list of outputs of format \code{list("output1"="type", "output2"="type", ...)}}

\item{wkID}{the workspace ID}

\item{authToken}{primary authorization token}
}
\value{
nested list, the first element is a list containing information about the new web service, the second element is a list of its endpoints
}
\description{
Publish a function to Microsoft Azure Machine Learning as a web service. The web service created is a standard Azure ML web service, and can be utilized from any web or mobile platform. as long as the user has the API key and URL. The function to be published can use arbitrary objects and packages. Currently, the function to be published can only take in primitive data types as input, i.e. no data frames or lists, but support for those functions will be added in the future.
}
\examples{
\dontrun{
add <- function(x,y) { return(x+y) }
newService <- publishWebService("add", "add",
 list("x"="int","y"="int"), list("z"="int"), wsID, authToken)
webserviceDetails <- newService[[1]]
endpoints <- newService[[2]]
helpURL <- endpoints[[1]]$HelpLocation
pKey <- endpoints[[1]]$PrimaryKey
apiURL <- endpoints[[1]]$ApiLocation
}
}
\seealso{
\code{\link{getWSDetails}} \code{\link{getEndpoints}} \code{\link{discoverSchema}} \code{\link{consumeLists}}

Other publishing functions: \code{\link{updateWebService}}
}

