% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/services.R
\name{services}
\alias{getWebServices}
\alias{services}
\title{List Available Web Services.}
\usage{
services(ws, service_id, name, host = ws$.management_endpoint)

getWebServices(ws, service_id, name, host = ws$.management_endpoint)
}
\arguments{
\item{ws}{An AzureML workspace reference returned by \code{\link{workspace}}.}

\item{service_id}{optional web service id. If supplied, return the web service information for just the specified service id. Leave undefined to return a data.frame of all services.}

\item{name}{optional web service name. If supplied, return the web service information for services with matching names. Leave undefined to return all services.}

\item{host}{the AzureML web services URI}
}
\value{
Returns a data.frame with variables:
\itemize{
  \item Id
  \item Name
  \item Description
  \item CreationTime
  \item WorkspaceId
  \item DefaultEndpointName
}
Each row of the returned data.frame corresponds to a service.
}
\description{
Return a list of web services available to the specified Microsoft Azure Machine Learning workspace.
The result is cached in the workspace environment similarly to datasets and experiments.
}
\note{
\code{getWebServices} is an alias for \code{services}.
}
\examples{
\dontrun{
workspace_id <- ""          # Your AzureML workspace id
authorization_token <- ""   # Your AzureML authorization token

ws <- workspace(
  id = workspace_id,
  auth = authorization_token
)

# Equivalent:
services(ws)
getWebServices(ws)
}
}
\seealso{
Other discovery functions: \code{\link{discoverSchema}},
  \code{\link{endpointHelp}}, \code{\link{endpoints}},
  \code{\link{workspace}}
}

