% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/azcopy.R
\name{call_azcopy}
\alias{call_azcopy}
\alias{azcopy}
\alias{azcopy_login}
\title{Call the azcopy file transfer utility}
\usage{
call_azcopy(...)

azcopy_login(force = FALSE)
}
\arguments{
\item{...}{Arguments to pass to AzCopy on the commandline. If no arguments are supplied, a help screen is printed.}

\item{force}{For \code{azcopy_login}, whether to force AzCopy to relogin. If \code{FALSE} (the default), and AzureStor has detected that AzCopy has already logged in, this has no effect.}
}
\description{
Call the azcopy file transfer utility
}
\details{
AzureStor has the ability to use the Microsoft AzCopy commandline utility to transfer files. To enable this, set the argument \code{use_azcopy=TRUE} in any call to an upload or download function; AzureStor will then call AzCopy to perform the file transfer rather than relying on its own code. You can also call AzCopy directly with the \code{call_azcopy} function, passing it any arguments as required.

AzureStor requires version 10 or later of AzCopy, which is a substantial rewrite and is currently (as of February 2019) in beta. The first time you try to run it, AzureStor will check that the version of AzCopy is correct, and throw an error if it is version 8 or earlier.

The AzCopy utility must be in your path for AzureStor to find it. Note that unlike earlier versions, Azcopy 10 is a single, self-contained binary file that can be placed in any directory.

AzCopy uses its own mechanisms for authenticating with Azure Active Directory, which is independent of the OAuth tokens used by AzureStor. AzureStor will try to ensure that AzCopy has previously authenticated before trying to transfer a file with a token, but this may not always succeed. You can run \code{azcopy_login(force=TRUE)} to force it to authenticate.
}
\seealso{
\href{https://docs.microsoft.com/en-us/azure/storage/common/storage-use-azcopy-v10}{AzCopy page on Microsoft Docs}

\href{https://github.com/Azure/azure-storage-azcopy}{AzCopy GitHub repo}
}
