% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adls_client_funcs.R
\name{adls_filesystem}
\alias{adls_filesystem}
\alias{adls_filesystem.character}
\alias{adls_filesystem.adls_endpoint}
\alias{print.adls_filesystem}
\alias{list_adls_filesystems}
\alias{list_adls_filesystems.character}
\alias{list_adls_filesystems.adls_endpoint}
\alias{create_adls_filesystem}
\alias{create_adls_filesystem.character}
\alias{create_adls_filesystem.adls_filesystem}
\alias{create_adls_filesystem.adls_endpoint}
\alias{delete_adls_filesystem}
\alias{delete_adls_filesystem.character}
\alias{delete_adls_filesystem.adls_filesystem}
\alias{delete_adls_filesystem.adls_endpoint}
\title{Operations on an Azure Data Lake Storage Gen2 endpoint}
\usage{
adls_filesystem(endpoint, ...)

\method{adls_filesystem}{character}(endpoint, key = NULL, token = NULL,
  sas = NULL, api_version = getOption("azure_storage_api_version"), ...)

\method{adls_filesystem}{adls_endpoint}(endpoint, name, ...)

\method{print}{adls_filesystem}(x, ...)

list_adls_filesystems(endpoint, ...)

\method{list_adls_filesystems}{character}(endpoint, key = NULL,
  token = NULL, sas = NULL,
  api_version = getOption("azure_storage_api_version"), ...)

\method{list_adls_filesystems}{adls_endpoint}(endpoint, ...)

create_adls_filesystem(endpoint, ...)

\method{create_adls_filesystem}{character}(endpoint, key = NULL,
  token = NULL, sas = NULL,
  api_version = getOption("azure_storage_api_version"), ...)

\method{create_adls_filesystem}{adls_filesystem}(endpoint, ...)

\method{create_adls_filesystem}{adls_endpoint}(endpoint, name, ...)

delete_adls_filesystem(endpoint, ...)

\method{delete_adls_filesystem}{character}(endpoint, key = NULL,
  token = NULL, sas = NULL,
  api_version = getOption("azure_storage_api_version"), ...)

\method{delete_adls_filesystem}{adls_filesystem}(endpoint, ...)

\method{delete_adls_filesystem}{adls_endpoint}(endpoint, name, confirm = TRUE, ...)
}
\arguments{
\item{endpoint}{Either an ADLSgen2 endpoint object as created by \link{storage_endpoint} or \link{adls_endpoint}, or a character string giving the URL of the endpoint.}

\item{...}{Further arguments passed to lower-level functions.}

\item{key, token, sas}{If an endpoint object is not supplied, authentication credentials: either an access key, an Azure Active Directory (AAD) token, or a SAS, in that order of priority. Currently the \code{sas} argument is unused.}

\item{api_version}{If an endpoint object is not supplied, the storage API version to use when interacting with the host. Currently defaults to \code{"2019-07-07"}.}

\item{name}{The name of the filesystem to get, create, or delete.}

\item{x}{For the print method, a filesystem object.}

\item{confirm}{For deleting a filesystem, whether to ask for confirmation.}
}
\value{
For \code{adls_filesystem} and \code{create_adls_filesystem}, an S3 object representing an existing or created filesystem respectively.

For \code{list_adls_filesystems}, a list of such objects.
}
\description{
Get, list, create, or delete ADLSgen2 filesystems.
}
\details{
You can call these functions in a couple of ways: by passing the full URL of the filesystem, or by passing the endpoint object and the name of the filesystem as a string.

If authenticating via AAD, you can supply the token either as a string, or as an object of class AzureToken, created via \link[AzureRMR:reexports]{AzureRMR::get_azure_token}. The latter is the recommended way of doing it, as it allows for automatic refreshing of expired tokens.
}
\examples{
\dontrun{

endp <- adls_endpoint("https://mystorage.dfs.core.windows.net/", key="access_key")

# list ADLSgen2 filesystems
list_adls_filesystems(endp)

# get, create, and delete a filesystem
adls_filesystem(endp, "myfs")
create_adls_filesystem(endp, "newfs")
delete_adls_filesystem(endp, "newfs")

# alternative way to do the same
adls_filesystem("https://mystorage.dfs.core.windows.net/myfs", key="access_key")
create_adls_filesystem("https://mystorage.dfs.core.windows.net/newfs", key="access_key")
delete_adls_filesystem("https://mystorage.dfs.core.windows.net/newfs", key="access_key")

}
}
\seealso{
\link{storage_endpoint}, \link{az_storage}, \link{storage_container}
}
