% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{bridge_sampler.angmcmc}
\alias{bridge_sampler.angmcmc}
\title{Log Marginal Likelihood via Bridge Sampling for angmcmc objects}
\usage{
\method{bridge_sampler}{angmcmc}(samples, ..., ave_over_chains = TRUE)
}
\arguments{
\item{samples}{angmcmc object}

\item{...}{additional argument passed to \link{bridge_sampler}}

\item{ave_over_chains}{logical. Separately call \link{bridge_sampler} on
each chain in the angmcmc object and then take the average? Defaults to \code{TRUE}.
See details.}
}
\description{
Log Marginal Likelihood via Bridge Sampling for angmcmc objects
}
\details{
Marginal likelihood is calculated by first converting the \code{angmcmc} object \code{samples} to an
\code{mcmc.list} object, and then by passing the resulting \code{mcmc.list} object to \link{bridge_sampler}.
If variablity across multiple chains (if any) are very different,
then calling \link{bridge_sampler} separately for each chain
usually provides more stable results; the final log ML is computed by averaging over
chain specific MLs.
}
\examples{
\dontrun{
library(future)
library(parallel)
plan(multiprocess)

set.seed(100)
MC.fit <- fit_angmix("vmsin", tim8, ncomp=3, n.iter=500,
                     n.chains = 3)

library(bridgesampling)
bridge_sampler(MC.fit)
}

}
