% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{AIC.angmcmc}
\alias{AIC.angmcmc}
\alias{BIC.angmcmc}
\title{AIC and BIC for angmcmc objects}
\usage{
\method{AIC}{angmcmc}(object, ..., k = 2)

\method{BIC}{angmcmc}(object, ...)
}
\arguments{
\item{object}{a fitted model object for which there exists a
    \code{logLik} method to extract the corresponding log-likelihood, or
    an object inheriting from class \code{logLik}.}

\item{...}{additional argument to be passed to \link{logLik.angmcmc}}

\item{k}{numeric, the \emph{penalty} per parameter to be used; the
    default \code{k = 2} is the classical AIC.}
}
\value{
AIC computes the AIC and BIC computes BIC for \code{angmcmc} objects.
}
\description{
AIC and BIC for angmcmc objects
}
\details{
Note that \code{AIC.angmcmc} and \code{BIC.angmcmc} calls \link{logLik.angmcmc},
which calculates Bayes estimate of the log-likelihood and *not* the maximum
likelihood. As such, care needs to be taken while using theses quantities.

\eqn{\hat{L}} is estimated by the sample maximum obtained from the MCMC realizations.
}
\examples{
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
AIC(fit.vmsin.20)
BIC(fit.vmsin.20)

}
