% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circ_cor.R
\name{circ_cor}
\alias{circ_cor}
\title{Sample circular correlation coefficients}
\usage{
circ_cor(x, type = "js")
}
\arguments{
\item{x}{two column matrix. NA values are not allowed.}

\item{type}{type of the circular correlation.
Must be one of "fl", "js", "tau1" and "tau2". See details.}
}
\description{
Sample circular correlation coefficients
}
\details{
\code{circ_cor} calculates the (sample) circular correlation between the columns of x.
Two parametric (the Jammalamadaka-Sarma (1988, equation 2.6) form \code{"js"}, and
the Fisher-Lee (1983, Section 3) form \code{"fl"})
and two non-parametric (two versions of Kendall's tau) correlation coefficients are considered.
The first version of Kendall's tau (\code{"tau1"}) is based on equation 2.1 in Fisher and Lee (1982),
whereas the second version (\code{"tau2"}) is computed using equations 6.7-6.8 in Zhan et al (2017).

The cost-complexity for \code{"js"}, \code{"fl"}, \code{"tau2"} and \code{"tau1"} are \eqn{O(n), O(n^2), O(n^2)} and \eqn{O(n^3)}
respectively, where \eqn{n} denotes the number of rows in \code{x}. As such, for large \eqn{n} evaluation of
\code{"tau1"} will be slow.
}
\examples{
# generate data from vmsin model
set.seed(1)
dat <- rvmsin(100, 2,3,-0.8,0,0)

# now calculate circular correlation(s) between the 2 columns of dat
circ_cor(dat, type="js")
circ_cor(dat, type="fl")
circ_cor(dat, type="tau1")
circ_cor(dat, type="tau2")


}
\references{
Fisher, N. I. and Lee, A. J. (1982). Nonparametric measures of angular-angular association. Biometrika, 69(2), 315-321.

Fisher, N. I. and Lee, A. J. (1983). A correlation coefficient for circular data. Biometrika, 70(2):327-332.

Jammalamadaka, S. R. and Sarma, Y. (1988). A correlation coefficient for
angular variables. Statistical theory and data analysis II, pages 349-364.

Zhan, X., Ma, T., Liu, S., & Shimizu, K. (2017). On circular correlation for data on the torus. Statistical Papers, 1-21.
}
