##' @title BAMMtools datasets
##'
##' @description Example datasets and sample \code{BAMM} output for the
##'     package \code{BAMMtools}.
##'
##' @name BAMMtools-data
##' @aliases whales primates fishes mcmc.whales mcmc.primates events.whales
##'     events.primates events.fishes mass.primates traits.fishes
##'
##' @docType data
##'
##' @details This includes both the raw data and the \code{BAMM} output for
##'     three example analyses. The first is an analysis of speciation and
##'     extinction rates during the radiation of modern whales, using a
##'     time-calibrated tree from Steeman et al. (2009). The second is a
##'     \code{BAMM} analysis of phenotypic evolutionary rates (body mass)
##'     during the radiation of extant primates, taken from Vos and Mooers
##'     (2006) and Redding et al. (2010).The third is a \code{BAMM} analysis
##'     of speciation and extinction rates for a 300-species subset of
##'     ray-finned fishes, along with body size data for these species from
##'     Rabosky et al. (2013). 
##'
##'     Dataset \code{whales} is the raw time-calibrated tree that was
##'     analyzed with \code{BAMM}, \code{primates} is the corresponding
##'     time-calibrated phylogeny of 233 primate species, and \code{fishes}
##'     is the time-calibrated phylogeny of 300 fish species. Log-transformed
##'     body masses for primates are in dataset \code{mass.primates}, and fish
##'     body sizes are in dataset \code{traits.fishes}.
##'
##'     The MCMC output files (\code{mcmc.whales} and \code{mcmc.primates})
##'     are dataframes containing the raw MCMC output as generated by
##'     \code{BAMM}. Column headers in the dataframes includes the sampling
##'     generation, the current number of shifts in the simulation
##'     (\code{N_shifts}), the log-prior density of the parameters
##'     (\code{logPrior}), the log-likelihood of the data (\code{logLik}), the
##'     current parameter of the Poisson process governing the number of
##'     regime shifts (\code{eventRate}), and the MCMC acceptance rate
##'     (\code{acceptRate}). This is the file that would typically be analyzed
##'     as a first step towards assessing MCMC convergence (e.g., analyzing
##'     effective sample sizes of \code{logLik} and \code{N_shifts}).
##'
##'     The "core" \code{BAMM} output is included in the \emph{event data}
##'     files (\code{events.whales}, \code{events.primates} and
##'     \code{events.fishes}). These are all the parameters sampled with MCMC
##'     that are relevant to reconstructing the nature and location of
##'     evolutionary rate dynamics across a phylogeny. Please refer to
##'     \code{BAMM} documentation for a detailed overview of this output, but
##'     a brief description is as follows:
##'
##'     \code{generation}: The index value of the state in the MCMC simulation
##'     (the "generation").
##'
##'     \code{leftchild, rightchild}: This defines a unique topological
##'     location where a rate shift was sampled. Specifically, for given
##'     right-left pair, the shift is sampled on the branch leading to the
##'     node from which \code{rightchild} and \code{leftchild} are descended
##'     (these two taxa are part of the spanning set of taxa for the node). If
##'     \code{leftchild} is "NA", this simply means that the shift was sampled
##'     on a terminal branch.
##'
##'     \code{abstime}: The absolute occurrence time of the shift, assuming
##'     that the time of the root node is 0.0.
##'
##'     \code{lambdainit, lambdashift}: For speciation extinction model, the
##'     initial speciation rate and rate change parameter for the process.
##'
##'     \code{muinit}: For speciation extinction model, the extinction rate
##'     (time-invariant).
##'
##'     \code{betainit, betashift}: For phenotypic evolutionary model, the
##'     initial (\code{betainit}) rate of phenotypic evolution and the rate
##'     change parameter (\code{betashift}).
##'
##' @source
##'     Vos R.A., A.O. Mooers. 2006. A new dated supertree of the Primates.
##'     Chapter 5. In Inferring large phylogenies: the big tree problem (R
##'     Vos, Ph.D. thesis) Simon Fraser University.
##'
##'     Redding D.W., C. DeWolff, A.O. Mooers. 2010. Evolutionary
##'     distinctiveness, threat status and ecological oddity in primates.
##'     Conservation Biology 24: 1052-1058. DOI:
##'     10.1111/j.1523-1739.2010.01532.x
##'
##'     Steeman, M.E., M.B. Hebsgaard, R.E. Fordyce, S.W.Y. Ho, D.L. Rabosky,
##'     R. Nielsen, C. Rahbek, H. Glenner, M.V. Sorensen, E. Willerslev. 2009.
##'     Radiation of Extant Cetaceans Driven by Restructuring of the Oceans.
##'     Systematic Biology. 58: 573-585. DOI: 10.1093/sysbio/syp060
##'
##'     Rabosky, D. L., F. Santini, J.T. Eastman, S. . Smith, B.L. Sidlauskas,
##'     J. Chang, and M.E. Alfaro. 2013. Rates of speciation and morphological
##'     evolution are correlated across the largest vertebrate radiation.
##'     Nature Communications DOI: 10.1038/ncomms2958.
##' @keywords datasets
##'
NULL
