if(!require("BB"))stop("this test requires package BB.")
if(!require("setRNG"))stop("this test requires setRNG.")

# Use a preset seed so test values are reproducable. 
test.rng <- list(kind="Mersenne-Twister", normal.kind="Inversion", seed=1236)
old.seed <- setRNG(test.rng)
#iseed <- 1236  # this seed was used for tests conducted on March 25, 2008.  
#set.seed(iseed)

broyds <- function(x) {
n <- length(x)
f <- rep(NA, n)
j <- 2:(n-1)
f[1] <- ((3 - 2*x[1]) * x[1] - 2 * x[2] + 1)^2
f[j] <- ((3 - 2*x[j]) * x[j] - x[j-1] - 2 * x[j+1] + 1)^2
f[n] <- ((3 - 2*x[n]) * x[n] - x[n-1] + 1)^2
f
}

p0 <- -sort(runif(500))
ans1 <- dfsane(par=p0, fn=broyds, method=1)
ans2 <- dfsane(par=p0, fn=broyds, method=2)
ans3 <- sane(par=p0, fn=broyds, method=1)
ans4 <- sane(par=p0, fn=broyds, method=2)
#ans <- nlsolve(p0, fn=broyds, method="L-BFGS-B")

c(ans1$resid, ans2$resid,ans3$resid, ans4$resid) #, ans$val) 
c(ans1$feval, ans2$feval,ans3$feval,ans4$feval) #, ans$counts[1]) 

# switched BFGS=TRUE to BFGS=FALSE below for speed, and 500 to 100
nsim <- 100
dfsane1.broyds <- dfsane2.broyds <- sane1.broyds <- sane2.broyds <- matrix(NA, nsim, 5)
for (i in 1:nsim) {
cat("Simulation" , i, "\n")
p0 <- -sort(runif(500))
t1 <- system.time(ans <- sane(par=p0, fn=broyds, method=1, control=list(BFGS=FALSE, trace=F)))[1]
if (!is.null(ans))sane1.broyds[i, ] <- c(ans$resid, ans$feval, ans$iter, ans$conv, t1)
t2 <- system.time(ans <- sane(par=p0, fn=broyds, method=2, control=list(BFGS=FALSE, trace=F)))[1]
if (!is.null(ans))sane2.broyds[i, ] <- c(ans$resid, ans$feval, ans$iter, ans$conv, t2)
t3 <- system.time(ans <- dfsane(par=p0, fn=broyds, method=1, control=list(BFGS=FALSE, trace=F)))[1]
if (!is.null(ans))dfsane1.broyds[i, ] <- c(ans$resid, ans$feval, ans$iter, ans$conv, t3)
t4 <- system.time(ans <- dfsane(par=p0, fn=broyds, method=2, control=list(BFGS=FALSE, trace=F)))[1]
if (!is.null(ans)) dfsane2.broyds[i, ] <- c(ans$resid, ans$feval, ans$iter, ans$conv, t4)
}

apply(sane1.broyds, 2, summary)
apply(sane2.broyds, 2, summary)
apply(dfsane1.broyds, 2, summary)
apply(dfsane2.broyds, 2, summary)

