get.landscape.BBMV <-
function(model,Npts=50,main='Macroevolutionary landscape',ylab='-V',xlab='Trait',xlim=NULL,ylim=NULL){
	# determine number of parameters of the model
	npar=length(model[[1]]) # 3: flat ; 4: linear ; 5: quadratic ; 6: x4
	# retrieve coefficients for the potential
	if (npar==3){a=b=c=0}
	if (npar==4){a=b=0 ; pars=model[[1]][-which(names(model[[1]])%in%c('bounds','sigsq','root_value'))] ; c=pars[[1]]}
	if (npar==5){a=0 ; pars=model[[1]][-which(names(model[[1]])%in%c('bounds','sigsq','root_value'))] ; b=pars[[1]] ; c=pars[[2]]}
	if (npar==6){a=model[[1]]$a ; b=model[[1]]$b ; c=model[[1]]$c}
	# build potential and stationary distribution of the trait
	SEQ=seq(from=-1.5,to=1.5,length.out=Npts)
	V=a*SEQ^4+b*SEQ^2+c*SEQ #potential
	bounds=model[[1]]$bounds
	if (is.null(xlim)){xlim=c(bounds[1],bounds[2])}
	if (is.null(ylim)){ylim=c(min(-V),max(-V))}
plot(-V~seq(from=bounds[1],to=bounds[2],length.out=Npts),type='l',col=2,lwd=3,main=main,xlab=xlab,ylab=ylab,xlim=xlim,ylim=ylim)
}
