% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceac_plot_graph.R
\name{ceac_plot_graph}
\alias{ceac_plot_graph}
\alias{ceac_plot_base}
\alias{ceac_plot_base.pairwise}
\alias{ceac_plot_base.bcea}
\alias{ceac_plot_ggplot}
\alias{ceac_plot_ggplot.pairwise}
\alias{ceac_plot_ggplot.bcea}
\alias{ceac_ggplot}
\alias{ceac_plot_plotly}
\title{Cost-Effectiveness Acceptability Curve (CEAC) Plot By Graph Device}
\usage{
ceac_plot_base(he, pos_legend, graph_params, ...)

\method{ceac_plot_base}{pairwise}(he, pos_legend, graph_params, ...)

\method{ceac_plot_base}{bcea}(he, pos_legend, graph_params, ...)

ceac_plot_ggplot(he, pos_legend, graph_params, ...)

\method{ceac_plot_ggplot}{pairwise}(he, pos_legend, graph_params, ...)

\method{ceac_plot_ggplot}{bcea}(he, pos_legend, graph_params, ...)

ceac_ggplot(he, pos_legend, graph_params, ceac, ...)

ceac_plot_plotly(he, pos_legend = "left", graph_params)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{pos_legend}{Legend position}

\item{graph_params}{Aesthetic ggplot parameters}

\item{...}{Additional arguments}

\item{ceac}{ceac index in he}
}
\description{
Choice of base R, ggplot2 or plotly.
}
\keyword{hplot}
\keyword{internal}
