% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attention.R
\docType{data}
\name{attention}
\alias{attention}
\title{Multiple Sources of Attentional Dysfunction in Adults With Tourette's Syndrome}
\format{A data.frame with 51 rows and 2 columns.}
\source{
\href{https://doi.org/10.1037/0894-4105.9.2.157}{
DOI:10.1037/0894-4105.9.2.157}
}
\usage{
data(attention)
}
\description{
Data from a psychological study comparing attentional performances of
Tourette's syndrome (TS) patients, ADHD patients, and controls.
These data were simulated using the sufficient statistics from Silverstein,
Como, Palumbo, West, and Osborn (1995).
}
\details{
\tabular{lll}{
   \strong{accuracy} \tab \code{numeric} \tab Participant's accuracy in the attentional task\cr
   \strong{group} \tab \code{factor} \tab Participant's group membership (TS patient, ADHD patient, or control)\cr
}
}
\references{
Silverstein, S. M., Como, P. G., Palumbo, D. R., West, L. L., & Osborn, L. M. (1995). Multiple sources of attentional dysfunction in adults with Tourette's syndrome: Comparison with attention deficit-hyperactivity disorder. Neuropsychology, 9(2), 157-164. https://doi.org/10.1037/0894-4105.9.2.157
\href{https://doi.org/10.1037/0894-4105.9.2.157}{
DOI:10.1037/0894-4105.9.2.157}
}
\keyword{datasets}
