% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcor_mat.R
\name{pcor_mat}
\alias{pcor_mat}
\title{Extract the Partial Correlation Matrix}
\usage{
pcor_mat(object, difference = FALSE, ...)
}
\arguments{
\item{object}{A model estimated with \strong{BGGM}. All classes are supported, assuming
there is matrix to be extracted.}

\item{difference}{Logical. Should the difference be returned (defaults to \code{FALSE}) ? Note
that this assumes there is a difference (e.g., an object of class \code{ggm_compare_estimate})
and ignored otherwise.}

\item{...}{Currently ignored.}
}
\value{
The estimated partial correlation matrix.
}
\description{
Extract the partial correlation matrix (posterior mean)
from \code{\link{estimate}}, \code{\link{explore}}, \code{\link{ggm_compare_estimate}},
and \code{\link{ggm_compare_explore}} objects. It is also possible to extract the
partial correlation differences for \code{\link{ggm_compare_estimate}} and
\code{\link{ggm_compare_explore}} objects.
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes

# data
Y <- ptsd[,1:5] + 1

# ordinal
fit <- estimate(Y, type = "ordinal",
                iter = 250,
                progress = FALSE)

pcor_mat(fit)
}
}
