% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.bgvar.R
\name{plot.bgvar.pred}
\alias{plot.bgvar.pred}
\title{Plot predictions of bgvar}
\usage{
\method{plot}{bgvar.pred}(x, ..., resp = NULL, Cut = 40)
}
\arguments{
\item{x}{an object of class \code{bgvar.predict}.}

\item{...}{additional arguments.}

\item{resp}{specify a variable to plot predictions.}

\item{Cut}{length of series to be plotted before prediction begins.}
}
\value{
No return value.
}
\description{
Plots the predictions of an object of class \code{bgvar.predict}.
}
\examples{
\dontshow{
library(BGVAR)
data(eerData)
cN<-c("EA","US","UK")
eerData<-eerData[cN]
W.trade0012<-apply(W.trade0012[cN,cN],2,function(x)x/rowSums(W.trade0012[cN,cN]))
model.ssvs.eer<-bgvar(Data=eerData,W=W.trade0012,saves=100,burns=100,plag=1,prior="SSVS",
                      eigen=TRUE)
fcast <- predict(model.ssvs.eer,fhorz=8,save.store=TRUE)
plot(fcast, resp="US.Dp", Cut=20)
}
\donttest{
library(BGVAR)
data(eerData)
model.ssvs.eer<-bgvar(Data=eerData,W=W.trade0012,saves=100,burns=100,plag=1,prior="SSVS",
                      eigen=TRUE)
fcast <- predict(model.ssvs.eer,fhorz=8,save.store=TRUE)
plot(fcast, resp="US.Dp", Cut=20)
}
}
\author{
Maximilian Boeck, Martin Feldkircher
}
