% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_trait_traitbygenus}
\alias{BIEN_trait_traitbygenus}
\title{Download trait data for given genus/genera and trait(s).}
\usage{
BIEN_trait_traitbygenus(
  genus,
  trait,
  all.taxonomy = FALSE,
  political.boundaries = FALSE,
  source.citation = F,
  ...
)
}
\arguments{
\item{genus}{A single genus or a vector of genera.}

\item{trait}{A single trait or a vector of traits.}

\item{all.taxonomy}{Should full taxonomic information and TNRS output be returned?  Default is FALSE.}

\item{political.boundaries}{Should political boundary information (country, state, etc.) be returned?  Default is FALSE.}

\item{source.citation}{Should readable source information be downloaded for each record?  Note that \code{\link{BIEN_metadata_citation}} may be more useful.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A dataframe of all data matching the specified trait(s) and genus/genera.
}
\description{
BIEN_trait_traitbygenus extracts entries that contain the specified genus/genera and trait(s).
}
\note{
Trait spelling needs to be exact and case-sensitive, see \code{\link{BIEN_trait_list}} for a list of traits.
}
\examples{
\dontrun{
BIEN_trait_traitbygenus(trait = "whole plant height", genus = "Carex")
trait_vector<-c("whole plant height", "leaf area")
genus_vector<-c("Carex","Betula")
BIEN_trait_traitbygenus(trait=trait_vector,genus=genus_vector)}
}
\seealso{
Other trait functions: 
\code{\link{BIEN_trait_country}()},
\code{\link{BIEN_trait_family}()},
\code{\link{BIEN_trait_list}()},
\code{\link{BIEN_trait_mean}()},
\code{\link{BIEN_trait_species}()},
\code{\link{BIEN_trait_traitbyfamily}()},
\code{\link{BIEN_trait_traitbyspecies}()},
\code{\link{BIEN_trait_traits_per_species}()},
\code{\link{BIEN_trait_trait}()}
}
\concept{trait functions}
