%% File Name: BIFIE.lavaan.survey.Rd
%% File Version: 0.210

\name{BIFIE.lavaan.survey}
\alias{BIFIE.lavaan.survey}
\alias{summary.BIFIE.lavaan.survey}
\alias{coef.BIFIE.lavaan.survey}
\alias{vcov.BIFIE.lavaan.survey}
\alias{BIFIE.survey}
\alias{summary.BIFIE.survey}
\alias{coef.BIFIE.survey}
\alias{vcov.BIFIE.survey}

%- Also NEED an '\alias' for EACH other topic documented here.

\title{
Fitting a Model in \pkg{lavaan} or in \pkg{survey}
}

\description{
The function \code{BIFIE.lavaan.survey} fits a structural equation model in \pkg{lavaan}
using the \pkg{lavaan.survey} package. Currently, only
maximum likelihood estimation for normally distributed data is available.

The function \code{BIFIE.survey} fits a model defined in the \pkg{survey} package.
}

\usage{
BIFIE.lavaan.survey(lavmodel, svyrepdes, lavaan_fun="sem",
    lavaan_survey_default=FALSE, fit.measures=NULL, ...)

\method{summary}{BIFIE.lavaan.survey}(object, ...)

\method{coef}{BIFIE.lavaan.survey}(object,...)

\method{vcov}{BIFIE.lavaan.survey}(object,...)

BIFIE.survey(svyrepdes, survey.function, ...)

\method{summary}{BIFIE.survey}(object, digits=3, ...)

\method{coef}{BIFIE.survey}(object,...)

\method{vcov}{BIFIE.survey}(object,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{lavmodel}{
Model string in \pkg{lavaan} syntax
}
  \item{svyrepdes}{
Replication design object of class \code{BIFIEdata} or replication design
object from \pkg{survey} package (generated by \code{\link{BIFIEdata2svrepdesign}} or
\code{\link[survey:svrepdesign]{survey::svrepdesign}})
}
\item{lavaan_fun}{Estimation funcion in \pkg{lavaan}. Can be \code{"lavaan"},
\code{"sem"}, \code{"cfa"} or \code{"growth"}.
}
\item{lavaan_survey_default}{Logical indicating whether the the \pkg{lavaan.survey}
package should be used for statistical inference for multiply imputed datasets.
}
\item{object}{Object of class \code{BIFIE.by}}
\item{fit.measures}{Optional vector of fit measures used in
\code{\link[lavaan:fitMeasures]{lavaan::fitMeasures}} function}
\item{\dots}{Further arguments to be passed}
\item{survey.function}{Function from the \pkg{survey} package}
\item{digits}{Number of digits after decimal}
}

%\details{
%%  ~~ If necessary, more details than the description above ~~
%}


\value{
For \code{BIFIE.lavaan.survey} a list with following entries
 \item{lavfit}{Object of class \code{lavaan}}
 \item{fitstat}{Fit statistics from \pkg{lavaan}}
}

%\references{
%% ~put references to the literature/web site here ~
%}

%\author{
%Alexander Robitzsch <a.robitzsch@bifie.at>
%}


%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link[lavaan:lavaan]{lavaan::lavaan}},
\code{\link[lavaan.survey:lavaan.survey]{lavaan.survey::lavaan.survey}}
}


\examples{
\dontrun{
#############################################################################
# EXAMPLE 1: Multiply imputed datasets, TIMSS replication design
#############################################################################

library(lavaan)
data(data.timss2)
data(data.timssrep)

#--- create BIFIEdata object
bdat4 <- BIFIEsurvey::BIFIE.data( data=data.timss2, wgt="TOTWGT",
                wgtrep=data.timssrep[,-1], fayfac=1)
print(bdat4)

#--- create survey object with conversion function
svydes4 <- BIFIEsurvey::BIFIEdata2svrepdesign(bdat4)

#*** regression model
mod1 <- BIFIEsurvey::BIFIE.linreg(bdat4, formula=ASMMAT ~ ASSSCI )
mod2 <- mitools::MIcombine( with(svydes4, survey::svyglm( formula=ASMMAT ~ ASSSCI,
                       design=svydes4 )))
#--- regression with lavaan.survey package
lavmodel <- "ASMMAT ~ 1
             ASMMAT ~ ASSSCI"
mod3 <- BIFIEsurvey::BIFIE.lavaan.survey(lavmodel, svyrepdes=svydes4)
# inference included in lavaan.survey package
mod4 <- BIFIEsurvey::BIFIE.lavaan.survey(lavmodel, svyrepdes=svydes4,
                        lavaan_survey_default=TRUE)
summary(mod3)
# extract fit statistics
lavaan::fitMeasures(mod3$lavfit)

#--- use BIFIE.lavaan.survey function with BIFIEdata object
mod5 <- BIFIEsurvey::BIFIE.lavaan.survey(lavmodel, svyrepdes=bdat4)
summary(mod5)

# compare estimated parameters
coef(mod1); coef(mod2); coef(mod3); coef(mod4); coef(mod5)

# compare standard error estimates
se(mod1); BIFIEsurvey::se(mod2); BIFIEsurvey::se(mod3); BIFIEsurvey::se(mod4); BIFIEsurvey::se(mod5)

#############################################################################
# EXAMPLE 2: Examples BIFIE.survey function
#############################################################################

data(data.timss2)
data(data.timssrep)

#--- create BIFIEdata object
bdat <- BIFIEsurvey::BIFIE.data( data=data.timss2, wgt="TOTWGT",
              wgtrep=data.timssrep[,-1], fayfac=1)
print(bdat)

#--- survey object
sdat <- BIFIEsurvey::BIFIEdata2svrepdesign(bdat)
print(sdat)

#- fit models in survey
mod1 <- BIFIEsurvey::BIFIE.linreg(bdat, formula=ASMMAT~ASSSCI)
mod2 <- BIFIEsurvey::BIFIE.survey( sdat, survey.function=survey::svyglm,
                                    formula=ASMMAT~ASSSCI)
mod3 <- BIFIEsurvey::BIFIE.survey( bdat, survey.function=survey::svyglm,
                                     formula=ASMMAT~ASSSCI)
summary(mod1)
summary(mod2)
summary(mod3)

#############################################################################
# EXAMPLE 3: Nested multiply imputed datasets | linear regression
#############################################################################

library(lavaan)
data(data.timss4)
data(data.timssrep)

# nested imputed dataset
bdat <- BIFIEsurvey::BIFIE.data( data.list=data.timss4,
            wgt=data.timss4[[1]][[1]]$TOTWGT, wgtrep=data.timssrep[, -1 ],  NMI=TRUE )
summary(bdat)

#*** BIFIEsurvey::BIFIE.linreg
mod1 <- BIFIEsurvey::BIFIE.linreg(bdat, formula=ASMMAT ~ migrant )

#*** survey::svyglm
mod2 <- BIFIEsurvey::BIFIE.survey(bdat, survey.function=survey::svyglm,
                                    formula=ASMMAT~migrant)

#*** lavaan.survey::lavaan.survey
lavmodel <- "ASMMAT ~ 1
             ASMMAT ~ migrant"
mod3 <- BIFIEsurvey::BIFIE.lavaan.survey(lavmodel, svyrepdes=bdat)

coef(mod1); coef(mod2); coef(mod3)
se(mod1); BIFIEsurvey::se(mod2), BIFIEsurvey::se(mod3)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%% \keyword{User defined function}
%% \keyword{summary}
%% \keyword{coef}
%% \keyword{vcov}

