% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{feldCoef}
\alias{feldCoef}
\title{Feldpausch et al. 2012 coefficients for generalized height-diameter models}
\format{A data frame with 12 observations on the following 4 variables:
\itemize{
\item \code{a}: Coefficient a
\item \code{b}: Coefficient b
\item \code{c}: Coefficient c
\item \code{RSE}: Vector of RSE
}}
\usage{
data("feldCoef")
}
\description{
Weibull coefficients from a height-diameter model of the form \eqn{H = a(1-exp(-b*D^c))} given by Feldpausch
et al. 2012. in the table 3, with the associated RSE.
}
\details{
This dataset is used in the function \code{\link[=retrieveH]{retrieveH()}}
to predict height from diameter depending on the region.
}
\examples{
data(feldCoef)
str(feldCoef)
}
\references{
Feldpausch, T.R., et al. (2012). \emph{Tree height integrated into pantropical forest biomass estimates}.
Biogeosciences, 9, 3381–3403.
}
\keyword{datasets}
\keyword{internal}
