% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizeBirds.R
\name{visits}
\alias{visits}
\alias{\sQuote{visits<-}}
\alias{visits<-}
\title{Get/set the visits}
\usage{
visits(x, name=NULL)

visits(x, name = NULL, useAsDefault = TRUE) <- value
}
\arguments{
\item{x}{An OrganizedBirds-object}

\item{name}{The name of the visit column. Default is \code{NULL}, which will
get/write to the predefined visit column (\code{visitUID}).}

\item{useAsDefault}{Specifies if the defined column in \code{name} should be used as
the default column for the visits in further analysis. If name is
\code{NULL} and \code{useAsDefault = TRUE}, \code{value} will be written to
column (\code{visitUID}) and that column will be set to default.}

\item{value}{the value to assign}
}
\description{
Gets or sets the visits identifier for a OrganizedBirds-class.
}
\examples{
ob <- organizeBirds(bombusObs)
attr(ob, "visitCol")
vis <- visits(ob)
tmp.vis <- createVisits(bombusObs,
                        idCols=c("locality"),
                        timeCols = c("day", "month", "year"),
                        gridIdCol = "id")
visits(ob, name = "visNoRecorder", useAsDefault = TRUE) <- tmp.vis
vis2 <- visits(ob)
attr(ob, "visitCol")
}
