% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-save_load.R
\name{save_model}
\alias{save_model}
\title{Save}
\usage{
save_model(model, loc)
}
\arguments{
\item{model}{A trained BKT model object to be saved.}

\item{loc}{Character. The file path where the model will be saved, typically with an \code{.rds} extension.}
}
\value{
None. The function saves the model to the specified location.
}
\description{
Save a BKT model to a file.
This function saves a trained BKT model to a specified file location. The model is stored
as an RDS file, which can be loaded back into R using the \code{load_model()} function.
}
\examples{
\donttest{
model <- bkt(seed = 42)
fit_model <- fit(model, data_path = "ct.csv")
save_model(fit_model, "bkt_model.rds")
}
}
