\name{Housing}
\alias{Housing}
\docType{data}
\title{Median home prices for 1984 and 1993 in 37 markets across the U.S.}
\description{
  Data for Exercise 5.82
}
\usage{Housing}
\format{
  A data frame with 37 observations on the following 3 variables.
  \describe{
    \item{\code{City}}{a factor with levels \code{Albany} \code{Anaheim} \code{Atlanta} \code{Baltimore} \code{Birmingham} \code{Boston} \code{Chicago} \code{Cincinnati} \code{Cleveland} \code{Columbus} \code{Dallas} \code{Denver} \code{Detroit} \code{Ft Lauderdale} \code{Houston} \code{Indianapolis} \code{Kansas City} \code{Los Angeles} \code{Louisville} \code{Memphis} \code{Miami} \code{Milwaukee} \code{Minneapolis} \code{Nashville} \code{New York} \code{Oklahoma City} \code{Philadelphia} \code{Providence} \code{Rochester} \code{Salt Lake City} \code{San Antonio} \code{San Diego} \code{San Francisco} \code{San Jose} \code{St Louis} \code{Tampa} \code{Washington}}
    \item{\code{X1984}}{a numeric vector}
    \item{\code{X1993}}{a numeric vector}
  }
}
\source{Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}. Duxbury}

\examples{
str(Housing)
attach(Housing)
stem(X1993)
stem(X1984)
par(mfrow=c(2,2))
stripchart(x=list(X1984,X1993),method="stack",pch=1,cex=1.2,col=c("orange","pink"),group.names=c("1984","1993"))
title(main="Problem 5.82 \n We have not talked about this kind of graph before...")
hist(X1993,breaks="Scott",col="pink")
hist(X1984,breaks="Scott",col="orange")
plot(density(X1993),col="red",xlab="",ylab="",main="",ylim=c(0,.00003))
lines(density(X1984),col="orange")
par(mfrow=c(1,1))
boxplot(X1993,X1984,col=c("pink","orange"),names=c("1993","1984"),main="Problem 5.82")
sign.test(X1984,conf.level=.98)
sign.test(X1993,conf.level=.98)
# 98% CI -> 63591.1 79622.56 and 85591.69 109915.4
# Placing on a common number line...
my.axis <- function(side, at, labels,...)
{for(i in seq(along=at)) axis(side=side, at=at[i], labels=labels[i],...) }

plot(1,type="n",xlim=c(63000,110000),ylim=c(0,1),
xlab="Median House Price",ylab="",yaxt="n",main="")
title(main="98 Percent Confidence Intervals")
my.axis(2,at=c(.25,.75),labels=c("1984","1993"), cex.axis=1.2 ,las=2)
lines( c(63591.1, 79622.56),c(.25,.25),col="orange",lwd=24)
lines( c(85591.69, 109915.4),c(.75,.75),col="pink",lwd=24)
detach(Housing)
}
\keyword{datasets}
