% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Indian}
\alias{Indian}
\title{Educational attainment versus per capita income and poverty rate for
American indians living on reservations}
\format{A data frame/tibble with ten observations on four variables
\describe{ 
\item{reservation}{a character variable with values \code{Blackfeet},
\code{Fort Apache}, \code{Gila River}, \code{Hopi}, \code{Navajo}, \code{Papago},
\code{Pine Ridge}, \code{Rosebud}, \code{San Carlos}, and \code{Zuni Pueblo}}
\item{percent high school}{percent who have graduated from high school} 
\item{per capita income}{per capita income (in dollars)} 
\item{poverty rate}{percent poverty} 
}}
\usage{
Indian
}
\description{
Data for Exercise 2.95
}
\examples{

par(mfrow = c(1, 2))
plot(`per capita income` ~ `percent high school`, data = Indian, 
     xlab = "Percent high school graudates", ylab = "Per capita income")
plot(`poverty rate` ~ `percent high school`, data = Indian, 
     xlab = "Percent high school graudates", ylab = "Percent poverty")
par(mfrow = c(1, 1))

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
