% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Smokyph}
\alias{Smokyph}
\title{Water pH levels of 75 water samples taken in the Great Smoky Mountains}
\format{
A data frame/tibble with 75 observations on three variables
\describe{ 
\item{waterph}{water sample pH level} 
\item{code}{charater variable with values \code{low} (elevation below 0.6 miles), 
and \code{high} (elevation above 0.6 miles)} 
\item{elev}{elevation in miles} 
}
}
\source{
Schmoyer, R. L. (1994), Permutation Tests for Correlation in Regression Errors,
\emph{Journal of the American Statistical Association, 89}, 1507-1516.
}
\usage{
Smokyph
}
\description{
Data for Exercises 6.40, 6.59, 7.10, and 7.35
}
\examples{

summary(Smokyph$waterph)
tapply(Smokyph$waterph, Smokyph$code, mean)
stripchart(waterph ~ code, data = Smokyph, method = "stack",
           pch = 19, col = c("red", "blue"))
           t.test(Smokyph$waterph, mu = 7)
           SIGN.test(Smokyph$waterph, md = 7)
           t.test(waterph ~ code, data = Smokyph, alternative = "less")
           t.test(waterph ~ code, data = Smokyph, conf.level = 0.90)
 \dontrun{
 library(ggplot2)
 ggplot2::ggplot(data = Smokyph, aes(x = waterph, fill = code)) + 
            geom_dotplot() + 
            facet_grid(code ~ .) + 
            guides(fill = FALSE)
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
