% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeStratPetersenDiagErrorWHSteel_fit.R
\name{TimeStratPetersenDiagErrorWHSteel_fit}
\alias{TimeStratPetersenDiagErrorWHSteel_fit}
\title{Wrapper (*_fit) and function to call the Time Stratified Petersen Estimator
with Diagonal Entries and separating Wild from Hatchery Steelhead function.}
\usage{
TimeStratPetersenDiagErrorWHSteel_fit(
  title = "TSPDE-WHSteel",
  prefix = "TSPDE-WHSteel-",
  time,
  n1,
  m2,
  u2.W.YoY,
  u2.W.1,
  u2.H.1,
  sampfrac = rep(1, length(u2.W.YoY)),
  hatch.after = NULL,
  bad.n1 = c(),
  bad.m2 = c(),
  bad.u2.W.YoY = c(),
  bad.u2.W.1 = c(),
  bad.u2.H.1 = c(),
  logitP.cov = as.matrix(rep(1, length(n1))),
  n.chains = 3,
  n.iter = 2e+05,
  n.burnin = 1e+05,
  n.sims = 2000,
  tauU.alpha = 1,
  tauU.beta = 0.05,
  taueU.alpha = 1,
  taueU.beta = 0.05,
  prior.beta.logitP.mean = c(logit(sum(m2, na.rm = TRUE)/sum(n1, na.rm = TRUE)), rep(0,
    ncol(as.matrix(logitP.cov)) - 1)),
  prior.beta.logitP.sd = c(stats::sd(logit((m2 + 0.5)/(n1 + 1)), na.rm = TRUE), rep(10,
    ncol(as.matrix(logitP.cov)) - 1)),
  tauP.alpha = 0.001,
  tauP.beta = 0.001,
  run.prob = seq(0, 1, 0.1),
  debug = FALSE,
  debug2 = FALSE,
  InitialSeed = ceiling(stats::runif(1, min = 0, 1e+06)),
  save.output.to.files = TRUE
)
}
\arguments{
\item{title}{A character string used for a title on reports and graphs}

\item{prefix}{A character string used as the prefix for created files. All
created graph files are of the form prefix-xxxxx.pdf.}

\item{time}{A numeric vector of time used to label the strata. For example,
this could be julian week for data stratified at a weekly level.}

\item{n1}{A numeric vector of the number of marked fish released in each
time stratum.}

\item{m2}{A numeric vector of the number of marked fish from n1 that are
recaptured in each time stratum. All recaptures take place within the
stratum of release. Use the \code{\link{TimeStratPetersenNonDiagError_fit}}
function for cases where recaptures take place outside the stratum of
release.}

\item{u2.W.YoY}{A numeric vector of the number of unmarked wild Young-of-Year
fish captured in each stratum.}

\item{u2.W.1}{A numeric vector of the number of unmarked wild age 1+ fish
captured in each stratum.}

\item{u2.H.1}{A numeric vector of the number of unmarked hatchery age 1+ fish
(i.e. adipose fin clipped) captured in each stratum.}

\item{sampfrac}{\strong{Deprecated} because it really doesn't work as intended.
You must remove all references to sampfrac from your code. Contact \email{cschwarz.stat.sfu.ca@gmail.com}
for more information.}

\item{hatch.after}{A numeric vector with elements belonging to \code{time}.
At which point do hatchery fish arrive? They arrive in the immediate stratum
AFTER these entries.}

\item{bad.n1}{A numeric vector with elements belonging to \code{time}.  In
some cases, something goes wrong in the stratum, and the number of marked
fish releases should be discarded.  The values of \code{n1} and \code{m2} will be set to
0 for these strata.}

\item{bad.m2}{A numeric vector with elements belonging to \code{time}.  In
some cases, something goes wrong in the stratum, and the number of recovered
marked fish should be ignored. For example, poor handling is suspected to
induce handling induced mortality in the marked fish and so only very few
are recovered.  The values of \code{n1} and \code{m2} will be set to 0
for these strata.}

\item{bad.u2.W.YoY}{A numeric vector with elements belonging to \code{time}.
In some cases, something goes wrong in the stratum, and the number of wild
unmarked Young-of-Year fish should be ignored.}

\item{bad.u2.W.1}{A numeric vector with elements belonging to \code{time}.
In some cases, something goes wrong in the stratum, and the number of wild
unmarked age 1+ fish should be ignored.}

\item{bad.u2.H.1}{A numeric vector with elements belonging to \code{time}.
In some cases, something goes wrong in the stratum, and the number of
hatchery unmarked (but adipose fin clipped) age 1+ fish should be ignored.}

\item{logitP.cov}{A numeric matrix for covariates to fit the
logit(catchability). Default is a single intercept, i.e. all strata have the
same mean logit(catchability).}

\item{n.chains}{Number of parallel MCMC chains to fit.}

\item{n.iter}{Total number of MCMC iterations in each chain.}

\item{n.burnin}{Number of burn-in iterations.}

\item{n.sims}{Number of simulated values to keeps for posterior
distribution.}

\item{tauU.alpha}{One of the parameters along with \code{tauU.beta} for the
prior for the variance of the random noise for the smoothing spline.}

\item{tauU.beta}{One of the parameters along with \code{tauU.alpha} for the
prior for the variance of the random noise for the smoothing spline.}

\item{taueU.alpha}{One of the parameters along with \code{taueU.beta} for
the prior for the variance of noise around the spline.}

\item{taueU.beta}{One of the parameters along with \code{taueU.alpha} for
the prior for the variance of noise around the spline.}

\item{prior.beta.logitP.mean}{Mean of the prior normal distribution for
logit(catchability) across strata}

\item{prior.beta.logitP.sd}{SD of the prior normal distribution for
logit(catchability) across strata}

\item{tauP.alpha}{One of the parameters for the prior for the variance in
logit(catchability) among strata}

\item{tauP.beta}{One of the parameters for the prior for the variance in
logit(catchability) among strata}

\item{run.prob}{Numeric vector indicating percentiles of run timing should
be computed.}

\item{debug}{Logical flag indicating if a debugging run should be made. In
the debugging run, the number of samples in the posterior is reduced
considerably for a quick turn around.}

\item{debug2}{Logical flag indicated if additional debugging information is
produced. Normally the functions will halt at \code{browser()} calls to
allow the user to peek into the internal variables. Not useful except to
package developers.}

\item{InitialSeed}{Numeric value used to initialize the random numbers used
in the MCMC iterations.}

\item{save.output.to.files}{Should the plots and text output be save to the files
in addition to being stored in the MCMC object?}
}
\value{
An MCMC object with samples from the posterior distribution. A
series of graphs and text file are also created in the working directory.
}
\description{
Takes the number of marked fish released, the number of recaptures, and the
number of unmarked fish and uses Bayesian methods to fit a fit a spline
through the population numbers and a hierarchical model for the trap
efficiencies over time.  The output is written to files and an MCMC object
is also created with samples from the posterior.
}
\details{
Normally, data is passed to the wrapper which then calls the fitting
function.
}
\examples{
 
##---- See the vignettes for example on how to use this package.

}
\references{
Bonner, S. J., & Schwarz, C. J. (2011). 
Smoothing population size estimates for Time-Stratified Mark-Recapture experiments Using Bayesian P-Splines. 
Biometrics, 67, 1498-1507. 
\doi{10.1111/j.1541-0420.2011.01599.x}

Schwarz, C. J., & Dempson, J. B. (1994).
Mark-recapture estimation of a salmon smolt population. 
Biometrics, 50, 98-108.

Schwarz, C.J., D. Pickard, K. Marine and S.J. Bonner. 2009. Juvenile Salmonid Outmigrant
Monitoring Evaluation, Phase II - December 2009. Final Technical Memorandum for the Trinity River
Restoration Program, Weaverville, CA. 155 pp. + appendices available at
\url{https://www.fws.gov/arcata/fisheries/reports/technical/TR_Final_Report.pdf}
}
\author{
Bonner, S.J. \email{sbonner6@uwo.ca} and 
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
\keyword{~models}
\keyword{~smooth}
