% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbd.R
\name{nbd.ConditionalExpectedTransactions}
\alias{nbd.ConditionalExpectedTransactions}
\title{NBD Conditional Expected Transactions}
\usage{
nbd.ConditionalExpectedTransactions(params, T.star, x, T.cal)
}
\arguments{
\item{params}{NBD parameters - a vector with \code{r} and \code{alpha}, in that order.}

\item{T.star}{Length of time for which we are calculating the expected number
of transactions.}

\item{x}{Number of repeat transactions in the calibration period \code{T.cal}, or a
vector of calibration period frequencies.}

\item{T.cal}{Length of calibration period, or a vector of calibration period
lengths.}
}
\value{
Number of transactions a customer is expected to make in a time
  period of length t, conditional on their past behavior. If any of the input
  parameters has a length greater than 1, this will be a vector of expected
  number of transactions.
}
\description{
Uses NBD model parameters and a customer's past transaction behavior to
return the number of transactions they are expected to make in a given time
period.
}
\examples{
data("groceryElog")
cbs <- elog2cbs(groceryElog, T.cal = "2006-12-31")
params <- nbd.EstimateParameters(cbs)
xstar.est <- nbd.ConditionalExpectedTransactions(params, cbs$T.star, cbs$x, cbs$T.cal)
sum(xstar.est) # expected total number of transactions during holdout
}
