% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.R
\name{pred.base}
\alias{pred.base}
\title{Bayesian prediction function}
\usage{
pred.base(samples, Fun, dens, len = 100, x0, method = c("vector", "free"),
  pred.alg = c("Distribution", "Trajectory"), sampling.alg = c("RejSamp",
  "InvMethod"), candArea, grid = 0.001)
}
\arguments{
\item{samples}{MCMC samples}

\item{Fun}{cumulative distribution function}

\item{dens}{density function}

\item{len}{number of samples to be drawn}

\item{x0}{vector of starting points}

\item{method}{vectorial ("vector") or not ("free")}

\item{pred.alg}{prediction algorithm, "Distribution" or "Trajectory"}

\item{sampling.alg}{sampling algorithm, rejection sampling ("RejSamp") or inversion method ("InvMethod")}

\item{candArea}{candidate area}

\item{grid}{fineness degree}
}
\value{
vector of samples from prediction
}
\description{
Drawing from predictive distribution based on distribution function \code{Fun(x, x0, samples)} or
 density \code{dens(x, x0, samples)}.
Samples should contain samples from the posterior distribution of the parameters.
}
\references{
Hermann, S. (2016). Bayesian Prediction for Stochastic Processes based on the Euler Approximation Scheme.
SFB 823 discussion paper 27/16.
}

