% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{methods}
\name{optimizeLP}
\alias{optimizeLP}
\alias{optimizeLP,Organism-method}
\title{Function for computing the linear programming according to the model structure}
\usage{
optimizeLP(object, lpob = object@lpobj, lb = object@lbnd,
  ub = object@ubnd, cutoff = 1e-06, j, sec_obj = "none")

\S4method{optimizeLP}{Organism}(object, lpob = object@lpobj,
  lb = object@lbnd, ub = object@ubnd, cutoff = 1e-06, j,
  sec_obj = "none")
}
\arguments{
\item{object}{An object of class Organisms.}

\item{lpob}{A linear programing object encoding the problem to solve.}

\item{lb}{A numeric vector giving the constraint values of lower bounds.}

\item{ub}{A numeric vector giving the constraint values of upper bounds.}

\item{cutoff}{value used to define numeric accuracy while interpreting optimization results}

\item{j}{debuging index to track cell}

\item{sec_obj}{character giving the secondary objective for a bi-level LP if wanted. Use "mtf" for minimizing total flux, "opt_rxn" for optimizing a random reaction, "opt_ex" for optimizing a random exchange reaction, and "sumex" for optimizing the sum of all exchange fluxes.}
}
\value{
Modified problem object according to the constraints and then solved with \code{optimizeProb}.
}
\description{
The generic function \code{optimizeLP} implements a linear programming based on the problem structure and refined constraints.
}
\details{
The parameter for sec_obj can be used to optimize a bi-level LP with a secondary objective if wanted. This can be helpful to subselect the solution space and create less alternative optimal solution. The secondary objective can be set to "mtf" to minimize the total flux, to simulate minimal enzyme usage of an organisms. If set to "opt_rxn" or "opt_ex", the secondary objective is picked as a random reaction or exchange reaction respectively everytime a fba is performed. This means that every individual of a population will select a different secondary reaction to optimize. The "sumex" option maximizes the secretion of products.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
org <- Organism(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a organism
org@fbasol <- optimizeLP(org)
}
\seealso{
\code{\link{Organism-class}}, \code{\link{optimizeProb}} and \code{\link{sysBiolAlg}}
}
