% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy-set.R
\name{tidySet}
\alias{tidySet}
\alias{tidySet.data.frame}
\alias{tidySet.list}
\alias{tidySet.matrix}
\alias{tidySet.Go3AnnDbBimap}
\title{Create a TidySet object}
\usage{
tidySet(relations)

\method{tidySet}{data.frame}(relations)

\method{tidySet}{list}(relations)

\method{tidySet}{matrix}(relations)

\method{tidySet}{Go3AnnDbBimap}(relations)
}
\arguments{
\item{relations}{An object to be coerced to a TidySet.}
}
\value{
A TidySet object.
}
\description{
These functions help to create a \code{TidySet} object from
\code{data.frame}, \code{list}, \code{matrix}, and \code{GO3AnnDbBimap}.
They can create both fuzzy and standard sets.
}
\details{
Elements or sets without any relation are not shown when printed.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: Given the relations in a data.frame

\item \code{list}: Convert to a TidySet from a list

\item \code{matrix}: Convert an incidence matrix into a TidySet

\item \code{Go3AnnDbBimap}: Convert Go3AnnDbBimap into a TidySet object.
}}

\examples{
relations <- data.frame(
    sets = c(rep("a", 5), "b"),
    elements = letters[seq_len(6)]
)
tidySet(relations)
relations2 <- data.frame(
    sets = c(rep("A", 5), "B"),
    elements = letters[seq_len(6)],
    fuzzy = runif(6)
)
tidySet(relations2)
# A
x <- list("A" = letters[1:5], "B" = LETTERS[3:7])
tidySet(x)
# A fuzzy set taken encoded as a list
A <- runif(5)
names(A) <- letters[1:5]
B <- runif(5)
names(B) <- letters[3:7]
relations <- list(A, B)
tidySet(relations)
# Will error
# x <- list("A" = letters[1:5], "B" = LETTERS[3:7], "c" = runif(5))
# a <- tidySet(x) # Only characters or factors are allowed as elements.
M <- matrix(c(1, 0.5, 1, 0), ncol = 2,
            dimnames = list(c("A", "B"), c("a", "b")))
tidySet(M)
}
\seealso{
\code{\link{TidySet-class}}
}
