% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mcmc.R
\name{BayesFBHborrow}
\alias{BayesFBHborrow}
\title{BayesFBHborrow: Run MCMC for a piecewise exponential model}
\usage{
BayesFBHborrow(
  data,
  data_hist = NULL,
  initial_parameters,
  hyperparameters,
  lambda_hyperparameters,
  iter,
  warmup_iter,
  refresh,
  verbose,
  max_grid
)
}
\arguments{
\item{data}{data.frame containing atleast three vectors of "tte" (time-to-event)
and "event" (censoring), and covariates "X_i" (where i should be a number/
indicator of the covariate)}

\item{data_hist}{data.frame containing atleast three vectors of "tte" 
 (time-to-event) and "event" (censoring), with the option of adding covariates
 named "X_0_i" (where i should be a number/
indicator of the covariate), for historical
 data}

\item{initial_parameters}{list containing the initial values of c("J", "s_r",
"mu", "sigma2", "tau", "lambda_0", "lambda", "beta_0", "beta")}

\item{hyperparameters}{list containing the hyperparameters c("a_tau", "b_tau",
"c_tau", "d_tau","type", "p_0", "a_sigma", "b_sigma", "Jmax", "clam_smooth",
 "cprop_beta", "phi", "pi_b")}

\item{lambda_hyperparameters}{contains two (three) hyperparameters (a, b (,alpha))
used for the update of lambda and lambda_0. alpha is the power parameter when 
sampling for lambda (effects how much is borrowed)}

\item{iter}{number of iterations for MCMC sampler}

\item{warmup_iter}{number of warmup iterations (burn-in) for MCMC sampler.}

\item{refresh}{number of iterations between printed screen updates}

\item{verbose}{TRUE (default), choice of output, if TRUE will output 
intermittent results into console}

\item{max_grid}{grids size for the smoothed baseline hazard}
}
\value{
list of samples for both fixed (can be found in $out_fixed) and 
multidimensional parameters (lambda, lambda_0, s, tau)
}
\description{
Main function of the BayesFBHborrow package. This generic function 
calls the correct MCMC sampler for time-to-event Bayesian borrowing.
}
\examples{
set.seed(123)
# Load the example data and write your initial values and hyper parameters
data(piecewise_exp_cc, package = "BayesFBHborrow")
data(piecewise_exp_hist, package = "BayesFBHborrow")

# Set your initial values and hyper parameters
s <- c(0, quantile(piecewise_exp_cc$tte, c(0.25, 0.75, 1.0), names = FALSE))
group_data_cc <- group_summary(piecewise_exp_cc[piecewise_exp_cc$X_trt == 0,]$tte, 
                               piecewise_exp_cc[piecewise_exp_cc$X_trt == 0,]$event, 
                               NULL, s)
group_data_hist <- group_summary(piecewise_exp_hist$tte, piecewise_exp_hist$event, NULL, s)
lambda_init_cc <- init_lambda_hyperparameters(group_data_cc, s) 
lambda_init_hist <- init_lambda_hyperparameters(group_data_hist, s) 
initial_param <- list("J" = 2, 
                      "s_r" = s[2:3], # split points only (length J) 
                      "mu" = 0, 
                      "sigma2" = 2,
                      "tau" = c( 1, 1, 1),
                      "lambda_0" = mapply(stats::rgamma, n=1, 
                                          shape = lambda_init_hist$shape, 
                                          rate = lambda_init_hist$rate), 
                      "lambda" = mapply(stats::rgamma, n=1, 
                                        shape = lambda_init_cc$shape, 
                                        rate = lambda_init_cc$rate), 
                       "beta_0" = NULL,
                       "beta" = 0)

hyper <-  list("a_tau" = 1, 
               "b_tau" = 0.001,
               "c_tau" = 1,
               "d_tau" = 10, 
               "type" = "mix",
               "p_0" = 0.5, 
               "a_sigma" = 2,
               "b_sigma" = 2,
               "Jmax" = 5, 
               "clam_smooth" = 0.5, 
               "cprop_beta" = 0.3,
               "phi" = 2, 
               "pi_b" = 0.5)

out <- BayesFBHborrow(piecewise_exp_cc, piecewise_exp_hist, initial_param, hyper,
                iter = 5, warmup_iter = 1)

# Create a summary of the output
# summary(out, estimator = "out_fixed")

# Plot some of the estimates
# Do beta (trace), s (hist) and lambda (matrix)
trace <- plot(out, 1:5, estimator = "beta_1", type = "trace")
hist <- plot(out, estimator = "J", type = "hist")
smoothed_baseline_hazard <- plot(out, 1:2000, estimator = "out_slam", 
                                 type = "matrix")
}
