% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapter-mass.R
\name{madapter.DiagCov}
\alias{madapter.DiagCov}
\title{Use the diagonal of sample covariance matrix as inverse mass matrix.}
\usage{
madapter.DiagCov(adapt_steps, windowlength, kappa = 0.5, epsilon = 1e-06)
}
\arguments{
\item{adapt_steps}{Number of adaptation steps}

\item{windowlength}{Lookback window length for calculation of covariance}

\item{kappa}{How much to shrink towards the identity}

\item{epsilon}{Small value to add to diagonal so as to avoid numerical
non-pos-def problem}
}
\value{
list containing `juliavar` and `juliacode` and all given arguments.
}
\description{
Use the diagonal of sample covariance matrix as inverse mass matrix.
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  madapter <- madapter.DiagCov(100, 10)
  sampler <- sampler.GGMC(madapter = madapter)
  ch <- mcmc(bnn, 10, 1000, sampler)
}

}
