% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc}
\alias{mcmc}
\title{Sample from a BNN using MCMC}
\usage{
mcmc(
  bnn,
  batchsize,
  numsamples,
  sampler = sampler.SGLD(stepsize_a = 1),
  continue_sampling = FALSE,
  start_value = NULL
)
}
\arguments{
\item{bnn}{A BNN obtained using \code{\link{BNN}}}

\item{batchsize}{batchsize to use; Most samplers allow for batching.
For some, theoretical justifications are missing (HMC)}

\item{numsamples}{Number of mcmc samples}

\item{sampler}{Sampler to use; See for example \code{\link{sampler.SGLD}} and
all other samplers start with `sampler.` and are thus easy to identity.}

\item{continue_sampling}{Do not start new sampling, but rather continue sampling
For this, numsamples must be greater than the already sampled number.}

\item{start_value}{Values to start from. By default these will be
sampled using the initialiser in `bnn`.}
}
\value{
a list containing the `samples` and the `sampler` used.
}
\description{
Sample from a BNN using MCMC
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  sampler <- sampler.SGNHTS(1e-3)
  ch <- mcmc(bnn, 10, 1000, sampler)
}

}
