% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectancy_dlm.R
\name{expectancy.DLM}
\alias{expectancy.DLM}
\title{DLM: Life expectancy}
\usage{
\method{expectancy}{DLM}(
  x,
  age = seq(0, max(fit$info$ages), by = 10),
  graph = TRUE,
  max_age = 110,
  prob = 0.95,
  ...
)
}
\arguments{
\item{x}{Object of the following classes: \code{DLM} or \code{ClosedDLM}.}

\item{age}{Numeric vector specifying the ages to calculate the life expectancy. The default is a sequence (0, 10, 20, ...) until the last decade used in the fitted model.}

\item{graph}{Logical value (TRUE ou FALSE). If TRUE, it also returns a plot. The default value is TRUE.}

\item{max_age}{Positive number indicating the last age to be considered to compute the life expectancy (prediction will be considered to match the age interval if needed). This argument is only necessary with objects of the class \code{DLM}.}

\item{prob}{A number specifying the probability of credible interval. The default value is 0.95.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A data.frame and (if graph = TRUE) a plot.
}
\description{
This function computes the life expectancy for each age for Dynamic Linear model.
}
\examples{
## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

# Example 1: --------------------------------

USA1990 = USA[USA$Year == 1990,]

Ex = USA1990$Ex.Total[1:111]
Dx = USA1990$Dx.Total[1:111]

qx_t <- Dx/Ex
qx_t <- 1 - exp(-qx_t)
y <- log(qx_t)

fit <- dlm(y, M = 100, bn = 20, thin = 1)
expectancy(fit)

# Example 2: -------------------------------

# Using some arguments:

expectancy(fit, age = c(0,20,30,60),
prob = 0.99, max_age = 90, graph = FALSE)


}
\seealso{
\code{\link[=expectancy.HP]{expectancy.HP()}} and \code{\link[=expectancy.BLC]{expectancy.BLC()}} for \code{HP} and \code{BLC} methods.

\code{\link[=Heatmap.DLM]{Heatmap.DLM()}} and \code{\link[=Heatmap.list]{Heatmap.list()}} for \code{DLM} or \code{list} methods to drawing a Heatmap for the truncated life expectancy.
}
