% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior_functions_methods}
\alias{prior_functions_methods}
\alias{rng}
\alias{cdf}
\alias{ccdf}
\alias{quant}
\alias{lpdf}
\alias{pdf}
\alias{mcdf}
\alias{mccdf}
\alias{mquant}
\alias{mlpdf}
\alias{mpdf}
\title{Creates generics for common statistical functions}
\usage{
rng(x, ...)

cdf(x, ...)

ccdf(x, ...)

quant(x, ...)

lpdf(x, ...)

pdf(x, ...)

mcdf(x, ...)

mccdf(x, ...)

mquant(x, ...)

mlpdf(x, ...)

mpdf(x, ...)
}
\arguments{
\item{x}{main argument}

\item{...}{unused arguments}
}
\value{
\code{pdf} (\code{mpdf}) and \code{lpdf} (\code{mlpdf}) give
the (marginal) density and the log of (marginal) density,
\code{cdf} (\code{mcdf}) and \code{ccdf} (\code{mccdf}) give the
(marginal) distribution and the complement of (marginal) distribution function,
\code{quant} (\code{mquant}) give the (marginal) quantile function,
and \code{rng} generates random deviates for an object of class 'prior'.

The \code{pdf} function proceeds to PDF graphics device if \code{x} is a character.
}
\description{
Density (pdf / lpdf), distribution
function (cdf / ccdf), quantile function (quant),
random generation (rng), mean, standard deviation (sd),
and marginal variants of the functions (mpdf, mlpf, mcdf,
mccdf, mquant).
}
