% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesGLM.R
\name{BayesGLM}
\alias{BayesGLM}
\title{BayesGLM for CIFTI}
\usage{
BayesGLM(
  BOLD,
  brainstructures = c("left", "right"),
  subROI = c("Amygdala-L", "Amygdala-R", "Caudate-L", "Caudate-R", "Hippocampus-L",
    "Hippocampus-R", "Thalamus-L", "Thalamus-R"),
  design,
  nuisance = NULL,
  scrub = NULL,
  hpf = NULL,
  TR = NULL,
  surfL = NULL,
  surfR = NULL,
  resamp_res = 10000,
  nbhd_order = 1,
  buffer = c(1, 1, 3, 4, 4),
  session_names = NULL,
  scale_BOLD = c("mean", "sd", "none"),
  Bayes = TRUE,
  hyperpriors = c("informative", "default"),
  ar_order = 6,
  ar_smooth = 5,
  aic = FALSE,
  n_threads = 4,
  return_INLA = c("trimmed", "full", "minimal"),
  verbose = 1,
  meanTol = 1e-06,
  varTol = 1e-06
)
}
\arguments{
\item{BOLD}{fMRI timeseries data in CIFTI format ("*.dtseries.nii").
For single-session analysis this can be a file path to a CIFTI file or a
\code{"xifti"} object from the \code{ciftiTools} package. For multi-session
analysis this can be a vector of file paths or a list of \code{"xifti"}
objects.

If \code{BOLD} is a \code{"xifti"} object(s), the surfaces, if any, will be
used for the spatial model. However, if \code{surfL} and \code{surfR} are
provided, they will override any surfaces in \code{BOLD}.}

\item{brainstructures}{Character vector indicating which brain structure(s)
of \code{BOLD} to analyze: \code{"left"} cortex; \code{"right"} cortex;
and/or \code{"subcortical"} structures. Or \code{"all"} to model all three.
Default: \code{c("left","right")} (cortex only).}

\item{subROI}{Which subcortical ROIs should be analyzed? Can be \code{"all"}
to analyze all subcortex ROIs. See the \code{ciftiTools_Name} column of
\code{ciftiTools:::substructure_table()} for a list of possible
subcortical ROIs.}

\item{design}{A numeric matrix or \code{data.frame}, or a
\code{"BayesfMRI_design"} object from \code{make_design}. Can also
be an array where the third dimension is the same length as the number of
data locations, to model each location with its own design.}

\item{nuisance}{(Optional) A \eqn{T \times N_{nuis}} matrix of nuisance signals,
where \eqn{T} is the number of timepoints and \eqn{N} is the number of
nuisance signals, or a list of these for multi-session analysis. Nuisance
signals are regressed from the fMRI data and design matrix prior to GLM
computation. Nuisance signals can include motion regressors, HRF derivatives
not being modeled as tasks, and other sources of noise.

Detrending/high-pass filtering is accomplished by adding DCT bases to the
nuisance matrix; see the parameters \code{hpf} and \code{DCT}.

Do not add spike regressors for scrubbing to the \code{nuisance} matrix.
Rather, provide these in \code{scrub} so that their corresponding timepoints
are also removed from the BOLD data after nuisance regression.}

\item{scrub}{(Optional) A \eqn{T \times N_{scrub}} matrix of spike regressors
(one 1 value at the timepoint to scrub, and 0 for all other values), or a
logical vector indicating the timepoints to scrub (\code{TRUE} to scrub, and
\code{FALSE} to keep). For multi-session data, a session-length list of
such matrices or logical vectors.

The spike regressors will be included in the nuisance
regression, and afterwards the timepoints indicated in \code{scrub} will be
removed from the BOLD data and design matrix.}

\item{hpf}{Add DCT bases to \code{nuisance} to apply a temporal high-pass
filter to the data, for detrending? \code{hpf} is the filter frequency.
Use \code{NULL} to skip detrending. Detrending is strongly recommended for
fMRI data, to help reduce the autocorrelation in the residuals, so
\code{NULL} will induce a warning. Use \code{"already"} to disable the
warning while skipping highpass filtering.

Using at least two DCT bases is as sufficient for detrending as using linear
and quadratic drift terms in the nuisance matrix. So if DCT detrending is
being used here, there is no need to add linear and quadratic drift terms to
\code{nuisance}.}

\item{TR}{Temporal resolution of the data, in seconds.}

\item{surfL, surfR}{For cortex spatial model. Left and right cortex surface
geometry in GIFTI format ("*.surf.gii"). These can be a file path to
a GIFTI file or a \code{"surf"} object from \code{ciftiTools}.

Surfaces can alternatively be provided through the \code{$surf} metadata in
\code{BOLD} if it is \code{"xifti"} data. If neither are provided, by default the
HCP group-average fs_LR inflated surfaces included in \code{ciftiTools} will be
used for the cortex spatial model.}

\item{resamp_res}{For cortex spatial model. The number of vertices to which
each cortical surface should be resampled, or \code{NULL} to not resample.

For computational feasibility, a value of \code{10000} (default) or lower is
recommended for Bayesian spatial modeling. If \code{Bayes=FALSE},
\code{resamp_res} can be set to \code{NULL} for full-resolution classical
modeling.}

\item{nbhd_order}{For volumetric model. What order neighborhood around data
locations to keep? \code{0} for no neighbors, \code{1} for 1st-order
neighbors, \code{2} for 1st- and 2nd-order neighbors, etc. Smaller values
will provide greater computational efficiency at the cost of higher variance
around the edge of the data.}

\item{buffer}{For volumetric model. The number of extra voxel layers around
the bounding box. Set to \code{NULL} for no buffer. (We recommend not
changing \code{buffer} unless you know what you're doing. Instead, to reduce
the number of boundary voxels, adjust \code{nbhd_order}).}

\item{session_names}{The names of the task-fMRI \code{BOLD} sessions, for
multi-session analysis. If not provided here, will be inferred from
\code{names(BOLD)}, inferred from \code{names(design)}, or generated
automatically, in that order.}

\item{scale_BOLD}{Controls scaling the BOLD response at each location.
\describe{
\item{"mean":}{   Scale the data to percent local signal change.}
\item{"sd":}{   Scale the data by local standard deviation.}
\item{"none":}{   Center the data but do not scale it.}
}}

\item{Bayes}{Perform spatial Bayesian modeling? Default: \code{TRUE}. If
\code{FALSE}, only perform classical (massive univariate) modeling. (The classical GLM
result is always returned, whether \code{Bayes} is \code{TRUE} or \code{FALSE}.)}

\item{hyperpriors}{Should informative or default non-informative hyperpriors be assumed on SPDE hyperparameters?}

\item{ar_order}{(For prewhitening) The order of the autoregressive (AR) model
to use for prewhitening. If \code{0}, do not prewhiten. Default: \code{6}.

For multi-session modeling, note that a single AR model is used; its
coefficients will be the average estimate from each session.}

\item{ar_smooth}{(For prewhitening) The FWHM parameter for spatially
smoothing the coefficient estimates for the AR model to use for
prewhitening. Recall that
\eqn{\sigma = \frac{FWHM}{2*sqrt(2*log(2)}}. Set to \code{0} to not smooth
the estimates. Default: \code{5}.}

\item{aic}{(For prewhitening) Use the Akaike information criterion (AIC) to
select AR model orders between \code{0} and \code{ar_order}? Default:
\code{FALSE}.}

\item{n_threads}{The maximum number of threads to use for parallel
computations: prewhitening parameter estimation, and the inla-program model
estimation. Default: \code{4}. Note that parallel prewhitening requires the
\code{parallel} package.}

\item{return_INLA}{Return the INLA model object? (It can be large.) Use
\code{"trimmed"} (default) returns the results sufficient for
\code{\link{activations}} and \code{\link{BayesGLM2}}; \code{"minimal"}
returns enough for \code{\link{BayesGLM2}} but not
\code{\link{activations}}; \code{"full"} returns the full \code{inla}
output.}

\item{verbose}{\code{1} (default) to print occasional updates during model
computation; \code{2} for occasional updates as well as running INLA in
verbose mode (if \code{Bayes}), or \code{0} for no printed updates.}

\item{meanTol, varTol}{Tolerance for mean and variance of each data location.
Locations which do not meet these thresholds are masked out of the analysis.
Default: \code{1e-6} for both.}
}
\value{
An object of class \code{"BayesGLM"}: a list with elements
\describe{
\item{betas_Bayesian}{The field coefficients for the Bayesian model.}
\item{betas_classical}{The field coefficients for the classical model.}
\item{GLMs_Bayesian}{The entire list of GLM results, except for parameters estimated for the classical model.}
\item{GLMs_classical}{Parameters estimated for the classical model from the GLM.}
\item{brainstructures}{\code{data.frame} summarizing the spatial features of each brain structure modeled.}
\item{sessions}{\code{data.frame} with the \code{name} and \code{nTime} of each BOLD session.}
\item{fields}{\code{data.frame} with the \code{name}, related \code{task}, and \code{HRF_order} of each field.}
}
}
\description{
Performs spatial Bayesian GLM for task fMRI activation with CIFTI-format
data. The cortex is modeled as a surface mesh, and subcortical structures
are modeled as distinct volumetric regions. Includes the pre-processing
steps of nuisance regression, prewhitening, scaling, and variance
normalization. Supports both single- and multi-session analysis. Can also
compute just the classical (spatially-independent)
}
\details{
To use \code{BayesGLM}, the design matrix must first be constructed
with \code{make_design}.
}
\section{Connectome Workbench Requirement}{


This function uses a system wrapper for the 'wb_command' executable. The
user must first download and install the Connectome Workbench, available
from https://www.humanconnectome.org/software/get-connectome-workbench .
}

\section{INLA Requirement}{

This function requires the \code{INLA} package, which is not a CRAN package.
See \url{https://www.r-inla.org/download-install} for easy installation instructions.
}

\section{INLA Latent Fields Limit}{

INLA computation times increase greatly when the number of columns in the
design matrix exceeds five: when there are more than five tasks, or more
than three tasks each with a temporal derivative modeled as a field. In
cases like the latter, we recommend modeling the temporal derivatives as
nuisance signals using the option \code{dHRF_as="nuisance"}, rather than
modeling the temporal derivatives as fields.
}

