% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_Bayesian_FROC.R
\name{fit_Bayesian_FROC}
\alias{fit_Bayesian_FROC}
\title{Fit model to  data}
\usage{
fit_Bayesian_FROC(dataList, ModifiedPoisson = FALSE,
  PreciseLogLikelihood = TRUE, DrawCurve = length(dataList$m) == 0,
  Drawcol = TRUE, summary = TRUE,
  make.csv.file.to.draw.curve = FALSE, mesh.for.drawing.curve = 10000,
  significantLevel = 0.7, new.imaging.device = TRUE, cha = 1,
  ite = 10000, DrawFROCcurve = TRUE, DrawAFROCcurve = FALSE,
  DrawCFPCTP = TRUE, dig = 5, war = floor(ite/5), see = 1234567,
  Null.Hypothesis = FALSE)
}
\arguments{
\item{dataList}{This is a variable in the function \code{rstan::sampling()} in which it is named \code{data}.



 For the single reader and single modality data, the \code{dataList} is the following forms:

\code{ dataList.Example <- list(       }

\code{            h = c(41,22,14,8,1),   }

\code{            f = c(1,2,5,11,13),    }

\code{            NL = 124,     }

\code{            NI = 63,    }

\code{            C = 5)         }

And using this object \code{dataList.Example}, we can apply \code{fit_Bayesian_FROC()} such as \code{fit_Bayesian_FROC(dataList.Example)}.






To make this \R object \code{dataList}, this package provide three functions:
please use one of the following codes to obtain an \R object representing FROC data:


\describe{
\item{  \code{ \link{convertFromJafroc}()}}{ If  data is a \emph{\strong{JAFROC xlsx}} formulation.}
\item{  \code{ \link{dataset_creator_new_version}()}}{ Enter TP and FP data \emph{\strong{by table}}. }
\item{  \code{ \link{create_dataset}()}}{ Enter TP and FP data by \emph{\strong{interactive}} manner.}
}

This package includes FROC datasets.
Before running the function, we can confirm dataset is correctly formulated by the function \strong{\code{ \link{viewdata}}}.


-------------------------------------------------------------------------------------------------


------------  \strong{Single reader and single modality (SRSC) case.}   --------------


------------------------------------------------------------------------------------------------

In single reader and single modality case (srsc), it should be a list which includes  \code{f, h, NL, NI, C}.
This list contains the following numeric vectors \code{f, h} and numerics \code{NL, NI, C} :
\describe{
\item{ \code{f}  }{Non-negative integer vector  specifying  number of False Alarms   associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{h}  }{Non-negative integer vector  specifying  number  of Hits  associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{NL} }{A positive integer, representing  Number of Lesions.}
\item{ \code{NI} }{A positive integer, representing  Number of Images. }
\item{ \code{C}  }{A positive integer, representing  Number of Confidence level. }
}




The detail of these dataset, see the datasets  endowed with this package.
'Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
Note that confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} in the program and do not refer from user input data, where \code{C} is the highest number of confidence levels.
So, you should write down your hits and false alarms vector so that it is compatible with this automatically created \code{c} vector.


\strong{\emph{ Example data:}}

 \emph{            A single reader and single modality case   }

------------------------------------------------------------------------------------------------------
\tabular{rccc}{
\code{NI=63,NL=124}   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
 In R console ->      \tab \code{ c} \tab   \code{f }  \tab   \code{h}  \cr
  -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
\emph{\strong{definitely present}}  \tab  5 \tab 1 \tab 41 \cr
 probably present   \tab  4 \tab 2 \tab 22 \cr
 equivocal          \tab  3 \tab 5 \tab 14  \cr
 perhaps present    \tab  2 \tab 11 \tab 8  \cr
 questionable       \tab  1 \tab 13 \tab 1  \cr
 }

---------------------------------------------------------------------------------------------------


*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP

Note that  in FROC data, all confidence level means \emph{present} (\emph{deseased, lesion}) case only, no confidence level indicating absent.. Since each reader marks their suspicous location only and it generate the hits and false alarms, \emph{thus} his confidenc level representing that lesion is \emph{present}.
In the absent case, reader dose not mark any locations and hence, the absent cofidence level does not relate this dataset. So, if reader think it is no lesion, then in such case confidence level is not needed.


Note that the first column of confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} automatically in the program and do not refer from user input data even if it is specified explicitly, where \code{C} is the highest number of confidence levels.
So you should check the compatibility of your data and the program's generating new confidence  level vector by
a table which can be displayed by the function \code{\link{viewdata}()}.









---------------------------------------------------------------------------------------

  \strong{Multiple readers and multiple modalities case, i.e., MRMC case}


---------------------------------------------------------------------------------------


For  multiple readers and multiple modalities case, i.e., MRMC case,
to apply the function \code{fit_Bayesian_FROC()}, an \R list object representing FROC data
must have components \code{m,q,c,h,f,NL,C,M,Q}:
\describe{
\item{ \code{C }  }{A positive integer, representing  the \emph{\strong{highest}} number of confidence level, this is a scalar.}
\item{ \code{M }  }{A positive integer vector, representing  the number of \emph{\strong{modalities}}.  }
\item{ \code{Q }  }{A positive integer, representing  the number of \emph{\strong{readers}}. }
\item{ \code{c }  }{A positive integer vector, representing  the \emph{\strong{confidence level}}. This vector must be made by \code{rep(rep(C:1), M*Q)} }
\item{ \code{m }  }{A positive integer vector, representing  the \emph{\strong{modality}} ID vector. }
\item{ \code{q }  }{A positive integer vector, representing  the \emph{\strong{reader}} ID vector.}
\item{ \code{h }  }{A positive integer vector, representing  the number of \emph{\strong{hits}} vector.}
\item{ \code{f }  }{A positive integer vector, representing  the number of \emph{\strong{false alarm}} vector.}
\item{ \code{NL }  }{A positive integer, representing  the Total number of \emph{\strong{lesions}} for all images, this is a scalar.}
}
The detail of these dataset, please see the example datasets ( the section \strong{See Also} in the below) in this package.



Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
its each confidence level vector also created in the program by \code{C}. So, to confirm
your false positives and hits are correctly correspond
to confidence levels,
you should confirm the orders by the function \code{\link{viewdata}()}.


\strong{\emph{ Example data:  }}

 \emph{          Multiple readers and multiple modalities case, i.e., MRMC case   }
---------------------------------------------------------------------------------------------------
\tabular{ccccc}{
 \strong{ ReaderID} \tab   \strong{ModalityID }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{q} \tab  \code{ m}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
  -------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr
  1 \tab 1 \tab 5 \tab  1\tab 15\cr
  1 \tab 2 \tab 4  \tab 3\tab 14\cr
  1 \tab 3 \tab 3  \tab 5\tab 5\cr
  1 \tab 1 \tab 2  \tab 5\tab 3\cr
  1 \tab 2 \tab 1  \tab 9\tab 4\cr
  1 \tab 3 \tab 5  \tab 1\tab 14\cr
  1 \tab 1 \tab 4  \tab 2\tab 13\cr
  1 \tab 2 \tab 3  \tab 2\tab 5\cr
  1 \tab 3 \tab 2 \tab 5\tab 3\cr
  2 \tab 1 \tab 1 \tab  6\tab 4\cr
  2 \tab 2 \tab 5  \tab 1\tab 14\cr
  2 \tab 3 \tab 4  \tab 1\tab 4\cr
  2 \tab 1 \tab 3  \tab 1\tab 1\cr
  2 \tab 2 \tab 2  \tab 2\tab 2\cr
  2 \tab 3 \tab 1  \tab 3\tab 2\cr
  2 \tab 1 \tab 5  \tab 1\tab 13\cr
  2 \tab 2 \tab 4 \tab 2\tab 4\cr
  2 \tab 3 \tab 3  \tab 1\tab 2\cr }
---------------------------------------------------------------------------------------------------}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE}, then Poisson rate of false alarm are \code{per lesion},
and if \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm are \code{per image}.
To know detail, refer the author's paper in which I explained per image and per lesion.}

\item{PreciseLogLikelihood}{Logical, that is \code{TRUE} or \code{FALSE}. If \code{PreciseLogLikelihood  = TRUE}(default), then Stan calculates the precise log likelihood with target formulation.

If \code{PreciseLogLikelihood  = FALSE}, then Stan calculates the log likelihood by dropping the constant terms in the likelihood function.
In past, I distinct the stan file, one is target formulation and the another is not. But non-target formulation cause some Jacobian warnning, thus I made all stanfile with target formulation when I uploaded to CRAN. Thus this variable is now meaningless.}

\item{DrawCurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the curve is to be drawn. TRUE or FALSE. If you want to draw the FROC and AFROC curves, then you set \code{DrawCurve =TRUE}, if not then \code{DrawCurve =FALSE}.
The reason why the author make this variable \code{DrawCurve} is that it takes long time in MRMC case to draw curves, and thus default value is \code{FALSE}.}

\item{Drawcol}{Logical: \code{TRUE} of \code{FALSE}. Whether the (A)FROC curve is to be drawn  by using color of dark theme. The default value is a \code{TRUE}.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; whether to list verbose data of estimates when printing. If TRUE then verbose summary and additional estimates are printed in the R console. If FALSE, the output is minimal. I regret, this variable name should be verbose.}

\item{make.csv.file.to.draw.curve}{Logical: \code{TRUE} of \code{FALSE}. Whether  to create a csv file. If TRUE then csv file is created in your desktop to draw an FROC curve and cumulative hits and false alarms by scatter plot. Default is FALSE since it took times to create csv files.}

\item{mesh.for.drawing.curve}{An integer indicating number of dots drawing the curves, default =10000.}

\item{significantLevel}{This is a number between 0 and 1. The results are shown if posterior probabilities are greater than this quantity.}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{cha}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{chains}.  A positive integer representing   the number of chains generated by Hamiltonian Monte Carlo method,
and, default = 1.}

\item{ite}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{iter}. A positive integer representing  the  number of samples generated by Hamiltonian Monte Carlo method,
and, default = 10000. If your model could not converge, then raise this number. Must be greater for more reliable estimates.}

\item{DrawFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether  the FROC curve  is to be drawn.}

\item{DrawAFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the  AFROC curve is to be drawn.}

\item{DrawCFPCTP}{Logical: \code{TRUE} of \code{FALSE}. Whether  the CFPCTP points are  to be drawn.}

\item{dig}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{iter}.   A positive integer representing   the Significant digits, used in stan Cancellation.
default = 5,}

\item{war}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{warmup}.  A positive integer representing the Burn in period, which must be less than \code{ite}. Defaults to
war = floor(ite/5)=10000/5=2000,}

\item{see}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{seed}.  A positive integer representing  seed used in stan,
default = 1234567.}

\item{Null.Hypothesis}{Logical, that is \code{TRUE} or \code{FALSE}.
If \code{Null.or.Alternative.Hypothesis  = FALSE}(default),
 then fit the \emph{alternative model} to \code{dataList}
If \code{Null.or.Alternative.Hypothesis  = TRUE},
 then fit the \emph{null model} to \code{dataList}.
 Note that the null model is constructed under the null hypothesis that
 all modality are same observer performance ability.
 The alternative model is made under the assumption that all modality are not same.
The reason why author creats this parameter is to test the null hypothesis by the Bayes factor.
But the result of test is not desired one for me. Thus the test is under construction.}
}
\value{
An object of class \code{ \link{stanfitExtended}} which is an inherited S4 class from the S4 class  \strong{\emph{\code{\link[rstan]{stanfit}}}}
  By  \code{rstan::sampling}, the function fit the author's FROC Bayesian models to user data.

Use this fitted model  object for sequential analysis, such as drawing the FROC curve and alternative FROC (AFROC) curves.

------------------------------------------------------------------------------------------------------------

----   Notations and simbols for the    \strong{Outputs of single reader and single modality case }       ------

----------------------------------------------------------------------------------------------------------------

In the following, the notations for estimated parameters are shown.

\code{ w  }   A real number representing \strong{ \emph{ the lowest threshold}} of the Gaussian assumption (binormal assumption). so \code{w}=\code{z[1]}.

\code{dz[1]  } A real number representing \strong{ \emph{the difference of the first and second threshold}} of the Gaussian assumption: \code{dz[1] := z[2] - z[1]}.

\code{dz[2]  } A real number representing the difference of the second and third threshold of the Gaussian assumption: \code{dz[2] :=  z[3] - z[2]}.

\code{dz[3]  } A real number representing the difference of the  third and fourth threshold of the Gaussian assumption: \code{dz[3] :=  z[4] - z[3]}.

\code{...}

\code{m  }A real number representing the The \strong{ \emph{  mean }}of the Latent Gaussian distribution for diseased images. In TeX, it denoted by \eqn{\mu}

\code{v  }A positive real number representing the \strong{ \emph{  standard deviation }}of the Latent Gaussian distribution for diseased images.In TeX, it will be denoted by \eqn{\sigma}, not the square of \eqn{\sigma}.

\code{p[1]} A real number representing the Hit rate with confidence level 1.

\code{p[2]}A real number representing the Hit rate with confidence level 2.

\code{p[3]}A real number representing the Hit rate with confidence level 3.

\code{...}

\code{l[1]}A positive real number representing the (Cumulative) False positive rate with confidence level 1. In TeX, it will be denoted by \eqn{\lambda_1}.

\code{l[2]}A positive real number representing the (Cumulative) False positive rate with confidence level 2. In TeX, it will be denoted by \eqn{\lambda_2}.

\code{l[3]}A positive real number representing the (Cumulative) False positive rate with confidence level 3. In TeX, it will be denoted by \eqn{\lambda_3}.

\code{l[4]}A positive real number representing the (Cumulative) False positive rate with confidence level 4. In TeX, it will be denoted by \eqn{\lambda_4}.

\code{...}

\code{dl[1]}A positive real number representing   the difference \code{ l[1] - l[2]}.

\code{dl[2]}A positive real number representing   the difference \code{ l[2] - l[3]}.

\code{dl[3]}A positive real number representing   the difference \code{ l[3] - l[4]}.

\code{...}

\code{z[1]} A real number representing the lowest threshold of the (Gaussian) binormal assumption.

\code{z[2]}  A real number representing the 2nd threshold of the (Gaussian) binormal assumption.

\code{z[3]} A real number representing the 3rd threshold of the (Gaussian) binormal assumption.

\code{z[4]} A real number representing the fourth threshold of the (Gaussian) binormal assumption.

\code{a} A real number   defined by \code{m/v}, please contact the author's paper for detail.

\code{b} A real number representing   defined by \code{1/v}, please contact the author's paper for detail.

\code{A} A positive real number  between 0 and 1, representing AUC, i.e., the area under the alternative ROC curve.

\code{lp__} The logarithmic likelihood of our model for your data.

---------------------------------------------------------------------------------------------------------------

---- \strong{Notations and simbols:  }Outputs of Multiple Reader and Multiple Modality case       ------

------------------------------------------------------------------------------------------------------------------

\code{ w  }    The lowest threshold of the Gaussian assumption (binormal assumption). so \code{w}=\code{z[1]}.

\code{dz[1]  } The difference of the first and second threshold of the Gaussian assumption.

\code{dz[2]  } The difference of the second and third threshold of the Gaussian assumption.

\code{dz[3]  } The difference of the  third and fourth threshold of the Gaussian assumption.

\code{...}

\code{mu  }The mean of the Latent Gaussian distribution for diseased images.

\code{v  }The variance of the Latent Gaussian distribution for diseased images.

\code{ppp[1,1,1]} Hit rate with confidence level 1, modaity 1, reader 1.

\code{ppp[2,1,1]} Hit rate with confidence level 2,  modality  1, reader 1.

\code{ppp[3,1,1]} Hit rate with confidence level 3,  modality  1, reader 1.

\code{...}

\code{l[1]} (Cumulative) False positive rate with confidence level 1.

\code{l[2]} (Cumulative) False positive rate with confidence level 2.

\code{l[3]} (Cumulative) False positive rate with confidence level 3.

\code{l[4]} (Cumulative) False positive rate with confidence level 4.

\code{...}

\code{dl[1]} This is defined by the difference \code{ l[1] - l[2]}.

\code{dl[2]} This is defined by the difference \code{ l[2] - l[3]}.

\code{dl[3]} This is defined by the difference \code{ l[3] - l[4]}.

\code{...}

\code{z[1]} The lowest threshold of the (Gaussian) binormal assumption.

\code{z[2]}  The 2nd threshold of the (Gaussian) binormal assumption.

\code{z[3]} The 3rd threshold of the (Gaussian) binormal assumption.

\code{z[4]} The fourth threshold of the (Gaussian) binormal assumption.

\code{aa} This is defined by \code{m/v}, please see the author's paper for more detail.

\code{bb} This is defined by \code{1/v}, please see the author's paper for more detail.

\code{AA} The area under alternative FROC curve associated to reader and modality.

\code{A} The area under alternative FROC curve associated to modality.

\code{hyper_v} Standard deviation of \code{AA} around \code{A}.

\code{lp__} The logarithmic likelihood of our model for your data.
}
\description{
Creates a fitted model object of class \code{ \link{stanfitExtended}}.
}
\details{
This function can be handled in MRMC data and It automatically detects whether the data was MRMC or not and adapts itself accordingly.


It also plots FROC curves if singler reader and single modality case.


 Build the S4 object by Stan to fit the author's Bayesian models introduced in the author's paper.
 The output of the \code{rstan::}\code{\link[rstan]{sampling}}() is an object of the S4 class called  \strong{\emph{\code{\link[rstan]{stanfit}}}}.
 But, in this package, we extended the \emph{stanfit} class to an S4 class named  \emph{stanfitExtended}.
 The new S4 class \strong{\code{ \link{stanfitExtended}}} included new slots for sequential analysis.
 So, the return value of the function is not the S4 class \emph{stanfit} but the new S4 class \strong{\code{ \link{stanfitExtended}}}.
 Thus, to apply the functions in the \strong{rstan} package for fitted model objects , we have to change the class of the S4 fitted model objects using the function \code{methods::}\code{\link[methods]{as}}() such as
 by the code \code{methods::as( object = fitted.model.object, "stanfit")}.

The following items are main substances of this function.

\describe{
\item{ \strong{\emph{What we can do by this function}}     }{}
\item{ \strong{\emph{-----------------------------------------[   FIT               ]--------------------------}}}{


* \code{rstan::}\code{\link[rstan]{sampling}}()   runs to demonstrate the author's Bayeisan model. Return is an object of class "stanfitExtended" that represents an Bayesiain FROC model. }
\item{ \strong{\emph{-----------------------------------------[   PLOT CURVES       ]--------------------------}}}{


* If dataset is a single reader and single modality, then the curves are drawn in default. But in the MRMC case,it tooks long time, so the plot is not done for this case.}
\item{ \strong{\emph{-----------------------------------------[  Create A fitted model object ]--------------------------}}}{


* The return value of this function is an S4 object whose class is inherited from the S4 class of the rstan package, which called stanfit.}
\item{ \strong{\emph{-----------------------------------------[  PRINT             ]--------------------------}}}{


* Estimates are printed in the R (Studio) console.}
}




This function \code{fit_Bayesian_FROC} is available both single reader and single modality case and multiple reader
and multiple modality case.
 Confidence level vector is not required but it is implicitly refered as the decreasing oreder,
For example, if C=3, then it would be a form  \code{c=c(3,2,1,3,2,1,...)}.
 Even if you write your data according to the order
\code{c=c(1,2,3,1,2,3,...)}, the program does not consider as your order, but \code{c=c(3,2,1,3,2,1,...)} instead.
}
\examples{
\donttest{

#==============================The first example=======================================

            # Making FROC Data and Fitting a Model to the data

  #                         Notations
  #            h = hits = TP = True Positives
  #            f = False alarms = FP = False Positives

#1) Build the data for singler reader and single modality  case.

dat <- list(c=c(3,2,1),    #Confidence level. Note that c is ignored.
            h=c(97,32,31), #Number of hits for each confidence level
            f=c(1,14,74),  #Number of false alarms for each confidence level

            NL=259,        #Number of lesions
            NI=57,         #Number of images
            C=3)           #Number of confidence level




#  where,
#        c denotes confidence level, i.e., rating of reader.
#                3 = Definitely deseased,
#                2 = subtle,.. deseased
#                1 = very subtle
#        h denotes number of hits (True Positives: TP) for each confidence level,
#        f denotes number of false alarms (False Positives: FP) for each confidence level,
#        NL denotes number of lesions,
#        NI denotes number of images,


# For example, in the above example data,
#  the number of hits with confidence level 3 is 97,
#  the number of hits with confidence level 2 is 32,
#  the number of hits with confidence level 1 is 31,

#  the number of false alarms with confidence level 3 is 1,
#  the number of false alarms with confidence level 2 is 14,
#  the number of false alarms with confidence level 1 is 74,

#2) Fit the FROC model.
  #Since dataset named dat are single reader and single modality,
  #the function build the such model by running the following code.





          fit <-   BayesianFROC::fit_Bayesian_FROC(
                               dat,       # dataset
                               ite=1111,  #To run in time <5s.
                               cha=1      # number of chains, it is better more large.
                               )





#3) Using the S4 object fit, we can go further step, such as calculation of the
# Chisquare and the p value of the Bayesian version for testing the goodness of fit.
# I think p value has problems that it relies on the sample size with monotonicity.
# But it is well used, thus I hate but I implement the p value.






# (( REMARK ))
# Should not write the above data as follows:

# MANNER (A)   dat <- list(c=c(1,2,3),h=c(31,32,97),f=c(74,14,1),NL=259,NI=57,C=3)


# Even if user write data in the above MANNER (A),
# the program interpret it as the following MANNER (B);

# MANNER (B)   dat <- list(c=c(3,2,1),h=c(31,32,97),f=c(74,14,1),NL=259,NI=57,C=3)

# Because the vecetor c is ingored in the program,
# and it is generated by  rep(C:1) automatically  in the internal of the function.
# So, we can omit c from the list.



#This package is very rigid format, so please be sure that your format is
#exactly same to the data in this package.
#More precisely, the confidence level vector should be denoted rep(C:1) (Not rep(1:C)).
#  Note that confidence level vector c  should not be specified.
#   If specified, will be ignored ,
#  since it is created by   c <-c(rep(C:1)) in the program and
#  do not refer from user input confidecnce level vector,
#  where C is the highest number of confidence levels.












#=======  The Second Example:  From data endowed in this package to fitting ============


#    (1)First, we prepare the data from this package.


                 dat  <- BayesianFROC::dataList.Chakra.1


#    (2)Second, we run fit_Bayesian_FROC() in which the rstan::stan() is implemented.
#    with data named "dat"  and the author's Bayesian model.


                 fit <-  fit_Bayesian_FROC(dat)






#   Now, we get the stan's out put, i.e.,  an S4 class object named "fit".

# << Minor Comments>>
#  More precisely, this is an S4 object of some inherited class (named stanfitExtended)
#  which is extended using stan's S4 class named "stanfit". This new S4 class
#  has new slots for the informations such as user data, plotting data for FROC curves,
#  input data to run this function, etc.

#  Using the output "fit",

#  we can use the functions in the "rstan" package, for example, as follows;


         rstan::stan_trace(fit)# stochastic process of a posterior estimate
         rstan::stan_hist(fit) # Histogram of a posterior estimate
         rstan::stan_rhat(fit) # Histogram of rhat for all parameters
         rstan::summary(fit)   # summary of fit by rstan








#================The third example:   Hand made data and fitting  ==========

#    Fit a model to a hand made data

#     1) Build the data for singler reader and single modality  case.

   dat <- list(
            c=c(3,2,1),    #  Confidence level, which is ignored.
            h=c(97,32,31), #  Number of hits for each confidence level
            f=c(1,14,74),  #  Number of false alarms for each confidence level

            NL=259,       #   Number of lesions
            NI=57,        #   Number of images
            C=3)          #   Number of confidence level




#  where,
#        c denotes confidence level, , each components indicates that
#                3 = Definitely lesion,
#                2 = subtle,
#                1 = very subtle
#          That is the high number indicates the high confidence level.
#        h denotes number of hits
#          (True Positives: TP) for each confidence level,
#        f denotes number of false alarms
#          (False Positives: FP) for each confidence level,
#        NL denotes number of lesions,
#        NI denotes number of images,


#     2) Fit  and draw FROC and AFROC curves.




           fit <-   fit_Bayesian_FROC(dat, DrawCurve = TRUE)



# (( REMARK ))
#           Changing the hits and false alarms denoted by h and  f
#           in the dataset denoted by dat, respectively,
#           user can draw the verious curves.
#           Enjoy drawing the curves for various single reader and single modality data.



#==========           The 4th example:  the data created by a function       ==========



#         1) Build the data by create_dataset() which endowed in this package.

                      dataList <-  create_dataset()

#Now, as as a return value of create_dataset(), we get the FROC data (list) named dataList.

#        2) Fit an MRMC or srsc FROC model.

                      fit <-  fit_Bayesian_FROC(dataList)





#========     The 5-th example:Comparison of the posterior probability for AUC ==========



# This example shows how to use the stanfit (stanfit.Extended) object.
# Using stanfit object, we can extract posterior samples and using these samples,
# we can calculate the posterior probability of research questions.



    fit <- fit_Bayesian_FROC(dataList.Chakra.Web.orderd,ite = 1111,summary =FALSE)



#    For example, we shall show the code to compute the posterior probability of the evet
#    that  the AUC of modality 1 is larger than that of modality 2:



                              e <- extract(fit)


# This code means that the MCMC samples are retained in the object e for all parameters.
# For example, the AUC is extracted by the code e$A and it is a two dimensional array.
# The first component indicates the MCMC samples and
# the second component indicate the modality ID.

# For example, the code e$A[,1] means the vector of MCMC samples of the 1 st modality.
# For example, the code e$A[,2] means the vector of MCMC samples of the 2 nd modality.
# For example, the code e$A[,3] means the vector of MCMC samples of the 3 rd modality.
#    To calculate the posterior probability of the evet
#    that the AUC of modality 1 is larger than that of modality 2,
#    we excute the following R script:

                        mean(e$A[,1] > e$A[,2])


#    Similarly, to compute the posterior probability that
#     the AUC of modality 1 is larger  than  that of modality 3:

                        mean(e$A[,1] > e$A[,3])


#    Similarly, to compute the posterior probability that
#     the AUC of modality 1 is larger  than  that of modality 4:

                        mean(e$A[,1] > e$A[,4])


#    Similarly, to compute the posterior probability that
#     the AUC of modality 1 is larger  than  that of modality 5:

                        mean(e$A[,1] > e$A[,5])


#    Similarly, to compute the posterior probability that
#     the AUC of modality 1 is larger  than  that of modality 5 at least 0.01


                        mean(e$A[,1] > e$A[,5]+0.01)


#      Similarly,

                 mean( e$A[,1] > e$A[,5] + 0.01 )
                 mean( e$A[,1] > e$A[,5] + 0.02 )
                 mean( e$A[,1] > e$A[,5] + 0.03 )
                 mean( e$A[,1] > e$A[,5] + 0.04 )
                 mean( e$A[,1] > e$A[,5] + 0.05 )
                 mean( e$A[,1] > e$A[,5] + 0.06 )
                 mean( e$A[,1] > e$A[,5] + 0.07 )
                 mean( e$A[,1] > e$A[,5] + 0.08 )



# Since any posterior distribution tends to the Dirac measure whose center is
# true parameter under the assumption that the model is correct in the sense that the
# true distribution is belongs to a family of models.
# Thus using this procedure, we will get
# the true parameter if any more large sample size we can take.


#      Close the graphic device to avoid errors in R CMD check.

                      Close_all_graphic_devices()


}# dottest

}
\references{
Bayesian Models for Free-response Receiver Operating Characteristic Analysis; Pre-print
}
\seealso{
\describe{

\strong{---------  Before fitting:} \emph{ create a dataset}

\item{ \code{ \link{convertFromJafroc}}  }{ Convert from JAFROC format xlsx file to the author's format}

\item{ \code{ \link{dataset_creator_new_version}}  }{Create an R object which represent user data.}

\item{ \code{ \link{create_dataset}}  }{Create an R object which represent user data.}

\strong{---------  Further subsequential analysis: Plot curves}
Using the result of fitting a Bayesian FROC model, we can go sequential analysis.
\item{ \code{ \link{DrawCurves}}  }{ for drawing free response ROC curves.}

\strong{---------  Further subsequential analysis: Validation of the Model}
\item{ \code{ \link{p_value_of_the_Bayesian_sense_for_chi_square_goodness_of_fit}}  }{  Calculation of a p-value in the Bayesian paradigm.}


 \strong{---------  \R objects of example datasets from real world or fictious:}

\item{ \code{\link{dataList.Chakra.1}}  }{A \code{list} for an example dataset of single reader and single modality data. The word Chakra in the dataset name means that it appears  in the paper of Chakraborty.  }



\item{ \code{\link{dataList.Chakra.2}}  }{A \code{list}  for an example dataset of single reader and single modality data. The word Chakra in the dataset name means that it appears  in the paper of Chakraborty.  }



\item{ \code{\link{dataList.Chakra.3}}  }{A \code{list}  for an example dataset of single reader and single modality data. The word Chakra in the dataset name means that it appears  in the paper of Chakraborty.  }



\item{ \code{\link{dataList.Chakra.4}}  }{A \code{list}  for an example dataset of single reader and single modality data. The word Chakra in the dataset name means that it appears  in the paper of Chakraborty.  }


\item{ \code{\link{dataList.high.ability}}  }{A \code{list}  for an example dataset of single reader and single modality data  }

\item{ \code{\link{dataList.low.ability}}  }{A \code{list}  for an example dataset of single reader and single modality data  }

\item{ \code{\link{dataList.Chakra.Web}}  }{A \code{list}  for an example dataset of multiple readers and  multiple modalities data. The word Chakra in the dataset name means that it appears  in the paper of Chakraborty. }

\item{ \code{\link{data.hier.ficitious}}  }{A \code{list}  for an example dataset of  multiple readers and  multiple modalities data }


\item{ \code{\link{dataList.High}}  }{A \code{list}  for an example dataset of single reader and single modality data   whose AUC is  high.}

\item{ \code{\link{dataList.Low}}  }{A \code{list}  for an example dataset of single reader and single modality data   whose AUC is  low.}

}

* **************************************************************************************

                          See  Vignettes for more details.

 **************************************************************************************
}
\author{
Issei Tsunoda
}
