% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.modelFits}
\alias{plot.modelFits}
\title{plot.modelFits}
\usage{
\method{plot}{modelFits}(
  x,
  gAIC = TRUE,
  avg_fit = TRUE,
  cr_intv = TRUE,
  alpha_CrI = 0.05,
  cr_bands = FALSE,
  alpha_CrB = c(0.05, 0.5),
  n_bs_smpl = 1000,
  acc_color = "orange",
  ...
)
}
\arguments{
\item{x}{An object of type modelFits}

\item{gAIC}{Logical value indicating whether gAIC values are shown in the plot. Default TRUE}

\item{avg_fit}{Logical value indicating whether average fit is presented in the plot. Default TRUE}

\item{cr_intv}{Logical value indicating whether credible intervals are included in the plot. Default TRUE}

\item{alpha_CrI}{Numerical value of the width of the credible intervals. Default is set to 0.05 (i.e 95\% CI are shown).}

\item{cr_bands}{Logical value indicating whether bootstrapped based credible bands are shown in the plot. Default FALSE}

\item{alpha_CrB}{Numerical vector of the width of the credible bands. Default is set to 0.05 and 0.5 (i.e 95\% CB and median are shown).}

\item{n_bs_smpl}{Number of bootstrap samples being used. Default set to 1000.}

\item{acc_color}{Color of the credible bands. Default set to "orange"}

\item{...}{optional parameter to be passed.}
}
\value{
A ggplot2 object
}
\description{
Plot function based on the ggplot2 package. Providing visualizations for each model and a average Fit.
Black lines show the fitted dose response models and an AIC based average model.
Dots indicate the posterior median and vertical lines show corresponding credible intervals (i.e. the variability of the posterior distribution of the respective dose group).
To assess the uncertainty of the model fit one can in addition visualize credible bands (default coloring as orange shaded areas).
The calculation of these bands is performed via the getBootstrapQuantiles() function.
The default setting is that these credible bands are not calculated.
}
\examples{
posterior_list <- list(Ctrl = RBesT::mixnorm(comp1 = c(w = 1, m = 0, s = 1), sigma = 2),
                       DG_1 = RBesT::mixnorm(comp1 = c(w = 1, m = 3, s = 1.2), sigma = 2),
                       DG_2 = RBesT::mixnorm(comp1 = c(w = 1, m = 4, s = 1.5), sigma = 2) ,  
                       DG_3 = RBesT::mixnorm(comp1 = c(w = 1, m = 6, s = 1.2), sigma = 2) ,
                       DG_4 = RBesT::mixnorm(comp1 = c(w = 1, m = 6.5, s = 1.1), sigma = 2))
models <- c("exponential", "linear")
dose_levels <- c(0, 1, 2, 4, 8)
fit <- getModelFits(models      = models,
                    posterior   = posterior_list,
                    dose_levels = dose_levels,
                    simple      = TRUE)
                           
plot(fit) 
}
