% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dateInfluence.BchronologyRun.R
\name{dateInfluence}
\alias{dateInfluence}
\title{Find the influence of the dates in a Bchronology run}
\usage{
dateInfluence(bchrRun, whichDate = "all", measure = c("KL", "absMeanDiff",
  "absMedianDiff"))
}
\arguments{
\item{bchrRun}{The output of a run of the \code{\link{Bchronology}} function}

\item{whichDate}{The chosen date to remove. Either \code{'all'} which removes each date in turn, or \code{'internal'} which removes all but the top/bottom dates, or the date number (in the order same order as in argument 1), or the name of the date from the Bchronology run output file.}

\item{measure}{Either \code{'KL'} for Kullback Leibler divergence (recommended); or \code{'absMeanDiff'} or \code{'absMedianDiff'} for distances in years from the mean/median age respectively}
}
\value{
Outputs some text providing the influence values for the date(s) in question. If given an assignment value also return a list containing all the probability distributions.
}
\description{
This function takes as input a \code{\link{Bchronology}} run and allows the user to estimate a value of 'influence' for either a particular date (by name or number), for all dates in a core (\code{whichDate = 'all'}), or for all internal dates (\code{whichDate = 'internal'}). It measures the influence by either the Kullback-Leibler divergence (\code{KL}), the absolute mean difference (\code{absMeanDiff}), or the absolute median difference (\code{absMedianDiff}).
}
\details{
The \code{KL} measure is preferred as it takes account of the full probability distributions but it lacks a simple interpretation. The best way to use it is with \code{whichDate = 'all'}: the largest value corresponds to the most influential date in the chronology. For simpler interpretation use \code{measure = 'absMeanDiff'} or \code{measure = 'absMedianDiff'} as for these the influence is measured in years. 

When the predictPositions from the original \code{Bchronology} run do not include those of the date(s) being left out then the function uses the closest position and reports a warning.
}
\examples{
\donttest{
data(Glendalough)
GlenOut = Bchronology(ages=Glendalough$ages,
                      ageSds=Glendalough$ageSds, 
                      calCurves=Glendalough$calCurves,
                      positions=Glendalough$position, 
                      positionThicknesses=Glendalough$thickness,
                      ids=Glendalough$id, 
                      predictPositions=seq(0,1500,by=10))
dateInfluence(GlenOut, whichDate = 4, measure = 'absMeanDiff')
}
}
\seealso{
\code{\link{Bchronology}}, \code{\link{summary.BchronologyRun}}, \code{\link{coreInfluence}}, \code{\link{choosePositions}}
}
