% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleAges.R
\name{sampleAges}
\alias{sampleAges}
\title{Get sample ages from a set of Bchron calibrated dates}
\usage{
sampleAges(CalDates, n_samp = 10000)
}
\arguments{
\item{CalDates}{A list created from either \code{\link{BchronCalibrate}}.}

\item{n_samp}{The desired number of samples}
}
\value{
A vector of length \code{n_samp} containing sample ages for the specified date
}
\description{
A function for extracting sample ages from Bchron calibrated dates
}
\details{
Sometimes it is useful to have a set of sample calendar ages for your calibrated dates. For example the samples might be required to create a credible/confidence interval, or to create another non-trivial function of calibrated dates, such as differences. By default the \code{\link{BchronCalibrate}} function provides a grid of ages and an associated density, similar to OxCal. This function extracts that information and uses the \code{\link{sample}} function to output the desired number of samples
}
\examples{
# Calibrate multiple ages and summarise them
ages = BchronCalibrate(ages=c(3445,11553,7456),ageSds=c(50,230,110),
                       calCurves=c('intcal20','intcal20','shcal20'))
# Get samples
age_samples = sampleAges(ages)
# Create a credible interval and the median for each date
apply(age_samples, 2, quantile, probs = c(0.05, 0.5, 0.95))
}
\seealso{
\code{\link{BchronCalibrate}}
}
