/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.TreeIntervals;
import dr.evolution.tree.Tree;
import dr.evomodel.coalescent.GaussianProcessSkytrackLikelihood;
import dr.evomodel.coalescent.MultiLociTreeSet;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import java.util.ArrayList;
import java.util.List;

public class GaussianProcessMultilocusSkytrackLikelihood
extends GaussianProcessSkytrackLikelihood
implements MultiLociTreeSet {
    int numTrees;
    int numIntervals;
    private List<Tree> treeList;
    private List<TreeIntervals> intervalsList;

    public GaussianProcessMultilocusSkytrackLikelihood(List<Tree> list, Parameter parameter, boolean bl, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Parameter parameter6, Parameter parameter7, Parameter parameter8, Parameter parameter9, Parameter parameter10, Parameter parameter11, Parameter parameter12, Parameter parameter13) {
        super("gpSkytrackLikelihood");
        this.popSizeParameter = parameter4;
        this.Tmrca = parameter13;
        this.changePoints = parameter7;
        this.numPoints = parameter12;
        this.precisionParameter = parameter;
        this.lambdaParameter = parameter3;
        this.betaParameter = parameter6;
        this.alphaParameter = parameter5;
        this.rescaleByRootHeight = bl;
        this.lambda_boundParameter = parameter2;
        this.GPcounts = parameter9;
        this.GPtype = parameter8;
        this.coalfactor = parameter10;
        this.CoalCounts = parameter11;
        this.addVariable(this.popSizeParameter);
        this.addVariable(this.precisionParameter);
        this.addVariable(this.changePoints);
        this.addVariable(parameter12);
        this.addVariable(parameter9);
        this.addVariable(parameter8);
        this.addVariable(parameter10);
        this.addVariable(this.lambda_boundParameter);
        this.addVariable(parameter11);
        this.setTree(list);
        this.numintervals = this.getIntervalCount();
        System.err.println("by getIntervalCount, I get:" + this.getIntervalCount());
        this.numcoalpoints = this.getCorrectFieldLength();
        System.err.println("by getCorrectField" + this.getCorrectFieldLength());
        this.GPcoalfactor = new double[this.numintervals];
        this.backupIntervals = new double[this.numintervals];
        this.GPCoalInterval = new double[this.numcoalpoints];
        this.storedGPCoalInterval = new double[this.numcoalpoints];
        this.CoalPosIndicator = new int[this.numcoalpoints];
        this.storedCoalPosIndicator = new int[this.numcoalpoints];
        this.CoalTime = new double[this.numcoalpoints];
        this.storedCoalTime = new double[this.numcoalpoints];
        this.storedGPcoalfactor = new double[this.numintervals];
        parameter9.setDimension(this.numintervals);
        parameter11.setDimension(this.numcoalpoints);
        parameter8.setDimension(this.numcoalpoints);
        parameter12.setParameterValue(0, this.numcoalpoints);
        this.popSizeParameter.setDimension(this.numcoalpoints);
        this.changePoints.setDimension(this.numcoalpoints);
        parameter10.setDimension(this.numcoalpoints);
        this.initializationReport();
        this.setupSufficientStatistics();
    }

    @Override
    protected void setTree(List<Tree> list) {
        this.treesSet = this;
        this.treeList = list;
        this.makeTreeIntervalList(list, true);
        this.numTrees = list.size();
    }

    private void makeTreeIntervalList(List<Tree> list, boolean bl) {
        if (this.intervalsList == null) {
            this.intervalsList = new ArrayList<TreeIntervals>();
        } else {
            this.intervalsList.clear();
        }
        for (Tree tree : list) {
            this.numIntervals += tree.getExternalNodeCount();
            this.intervalsList.add(new TreeIntervals(tree));
            if (!bl || !(tree instanceof TreeModel)) continue;
            this.addModel((TreeModel)tree);
        }
    }

    @Override
    protected int getCorrectFieldLength() {
        return this.numIntervals - this.treeList.size();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model instanceof TreeModel) {
            TreeModel treeModel = (TreeModel)model;
            int n2 = this.treeList.indexOf(treeModel);
            if (n2 < 0) {
                throw new RuntimeException("Unknown tree modified in GMRFSkygridLikelihood");
            }
        } else {
            throw new RuntimeException("Unknown object modified in GMRFSkygridLikelihood");
        }
        this.makeTreeIntervalList(this.treeList, false);
        this.intervalsKnown = false;
        this.likelihoodKnown = false;
    }

    @Override
    public void initializationReport() {
        System.out.println("Creating a GP based estimation of effective population size trajectories for multiple loci:");
        System.out.println("\tIf you publish results using this model, please reference: ");
        System.out.println("\t\tPalacios, Minin and Suchard (XXXX)");
    }

    @Override
    protected void setupSufficientStatistics() {
    }

    protected double calculateLogCoalescentLikelihood() {
        double d = 0.0;
        return d;
    }

    protected double calculateLogFieldLikelihood() {
        double d = 0.0;
        return d;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogCoalescentLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    protected double getFieldScalar() {
        return 1.0;
    }

    @Override
    public int nLoci() {
        return this.treeList.size();
    }

    @Override
    public Tree getTree(int n) {
        return this.treeList.get(n);
    }

    @Override
    public TreeIntervals getTreeIntervals(int n) {
        return this.intervalsList.get(n);
    }

    @Override
    public double getPopulationFactor(int n) {
        return 1.0;
    }

    @Override
    public void storeTheState() {
        for (TreeIntervals treeIntervals : this.intervalsList) {
            treeIntervals.storeState();
        }
    }

    @Override
    public void restoreTheState() {
        for (TreeIntervals treeIntervals : this.intervalsList) {
            treeIntervals.restoreState();
        }
    }
}

