/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.ArrayList;

public class TreeBitRandomWalkOperator
extends SimpleMCMCOperator {
    private TreeModel tree;
    private String indicatorTrait;
    private String trait2;
    private int k;
    private boolean swapTrait2 = true;

    public TreeBitRandomWalkOperator(TreeModel treeModel, String string, String string2, double d, int n, boolean bl) {
        this.tree = treeModel;
        this.indicatorTrait = string;
        this.trait2 = string2;
        if (this.indicatorTrait == null) {
            this.indicatorTrait = "trait";
        }
        this.k = n;
        this.swapTrait2 = bl;
        this.setWeight(d);
    }

    @Override
    public final double doOperation() {
        NodeRef nodeRef;
        NodeRef nodeRef2;
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        for (int i = 0; i < this.tree.getNodeCount(); ++i) {
            nodeRef2 = this.tree.getNode(i);
            if (this.tree.getNodeTrait(nodeRef2, this.indicatorTrait) != 1.0) continue;
            arrayList.add(nodeRef2);
        }
        if (arrayList.size() == 0) {
            throw new RuntimeException("No suitable bits!");
        }
        nodeRef2 = nodeRef = (NodeRef)arrayList.get(MathUtils.nextInt(arrayList.size()));
        for (int i = 0; i < this.k; ++i) {
            int n = MathUtils.nextInt(3);
            if (n < 2) {
                if (this.tree.isExternal(nodeRef2)) continue;
                nodeRef2 = this.tree.getChild(nodeRef2, n);
                continue;
            }
            if (this.tree.isRoot(nodeRef2)) continue;
            nodeRef2 = this.tree.getParent(nodeRef2);
        }
        if (nodeRef == nodeRef2) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = this.tree.getNodeTrait(nodeRef, this.indicatorTrait);
        double d2 = this.tree.getNodeTrait(nodeRef2, this.indicatorTrait);
        this.tree.setNodeTrait(nodeRef, this.indicatorTrait, d2);
        this.tree.setNodeTrait(nodeRef2, this.indicatorTrait, d);
        if (this.swapTrait2) {
            if (this.trait2 != null) {
                d = this.tree.getNodeTrait(nodeRef, this.trait2);
                d2 = this.tree.getNodeTrait(nodeRef2, this.trait2);
                this.tree.setNodeTrait(nodeRef, this.trait2, d2);
                this.tree.setNodeTrait(nodeRef2, this.trait2, d);
            } else {
                double d3 = this.tree.getNodeRate(nodeRef);
                double d4 = this.tree.getNodeRate(nodeRef2);
                this.tree.setNodeRate(nodeRef, d4);
                this.tree.setNodeRate(nodeRef2, d3);
            }
        }
        return 0.0;
    }

    public final int rateChange(TreeModel treeModel, NodeRef nodeRef) {
        return (int)Math.round(treeModel.getNodeTrait(nodeRef, this.indicatorTrait));
    }

    @Override
    public final String getOperatorName() {
        return "treeBitRandomWalk(" + this.indicatorTrait + ")";
    }

    public final String getPerformanceSuggestion() {
        return "no performance suggestion";
    }

    public String toString() {
        return this.getOperatorName();
    }
}

