/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;

public class InfinitesimalRatesLogger
implements Loggable {
    private final SubstitutionModel substitutionModel;
    private double[] generator;

    public InfinitesimalRatesLogger(SubstitutionModel substitutionModel) {
        this.substitutionModel = substitutionModel;
    }

    @Override
    public LogColumn[] getColumns() {
        int n = this.substitutionModel.getDataType().getStateCount();
        if (this.generator == null) {
            this.generator = new double[n * n];
        }
        LogColumn[] logColumnArray = new LogColumn[n * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                final int n2 = i * n + j;
                logColumnArray[n2] = new NumberColumn(this.substitutionModel.getId() + "." + (i + 1) + "." + (j + 1)){

                    @Override
                    public double getDoubleValue() {
                        if (n2 == 0) {
                            InfinitesimalRatesLogger.this.substitutionModel.getInfinitesimalMatrix(InfinitesimalRatesLogger.this.generator);
                        }
                        return InfinitesimalRatesLogger.this.generator[n2];
                    }
                };
            }
        }
        return logColumnArray;
    }
}

