% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jbd_coordCountryInconsistent.R
\name{jbd_coordCountryInconsistent}
\alias{jbd_coordCountryInconsistent}
\title{Flags coordinates that are inconsistent with the stated country name}
\usage{
jbd_coordCountryInconsistent(
  data = NULL,
  lon = "decimalLongitude",
  lat = "decimalLatitude",
  scale = 50,
  pointBuffer = 0.01,
  stepSize = 1e+06,
  mc.cores = 1
)
}
\arguments{
\item{data}{A data frame or tibble. Occurrence records as input.}

\item{lon}{Character. The name of the column to use as longitude. Default = "decimalLongitude".}

\item{lat}{Character. The name of the column to use as latitude. Default = "decimalLatitude".}

\item{scale}{Numeric or character. To be passed to \code{\link[rnaturalearth:ne_countries]{rnaturalearth::ne_countries()}}'s scale.
Scale of map to return, one of 110, 50, 10 or "small", "medium", "large".
Smaller values return higher-resolution maps.}

\item{pointBuffer}{Numeric. Amount to buffer points, in decimal degrees. If the point is outside
of a country, but within this point buffer, it will not be flagged. Default = 0.01.}

\item{stepSize}{Numeric. The number of occurrences to process in each chunk. Default = 1000000.}

\item{mc.cores}{Numeric. If > 1, the st_intersects function will run in parallel
using mclapply using the number of cores specified. If = 1 then it will be run using a serial
loop. NOTE: Windows machines must use a value of 1 (see ?parallel::mclapply). Additionally,
be aware that each thread can use large chunks of memory.
Default = 1.}
}
\value{
The input occurrence data with a new column, .coordinates_country_inconsistent
}
\description{
Compares stated country name in an occurrence record with record's coordinates using
rnaturalearth data. The prefix, jbd_ is meant
to distinguish this function from the original \code{\link[bdc:bdc_coordinates_country_inconsistent]{bdc::bdc_coordinates_country_inconsistent()}}.
This functions will preferably use the countryCode and country_suggested columns
generated by \code{bdc::bdc_country_standardized()}; please run it on your dataset prior to running
this function.
}
\examples{

beesRaw_out <- jbd_coordCountryInconsistent(
  data = BeeBDC::beesRaw,
  lon = "decimalLongitude",
  lat = "decimalLatitude",
  scale = 50,
  pointBuffer = 0.01)
}
