% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{bevimed}
\alias{bevimed}
\title{Perform inference under model gamma = 1}
\usage{
bevimed(y, G, min_ac = 1L, q_shape = c(2, 100), p_shape = c(10, 2),
  omega_shape = if (max(min_ac) == 1L) c(2, 9) else c(2, 2),
  samples_per_chain = 2000, stop_early = FALSE, blocks = 5,
  burn = as.integer(samples_per_chain/10), temperatures = (0:10/10)^2,
  tune_temps = 0, store_Z_trace = TRUE,
  swaps = as.integer(length(temperatures)/2), optimise_Z0 = FALSE,
  tune_omega_and_phi_proposal_sd = FALSE, tune_block_size = 100,
  variant_weights = NULL, log_phi_mean = -1.5, log_phi_sd = 1,
  tandem_variant_updates = if (max(min_ac) == 1) 0 else min(sum(y), nrow(G)),
  ...)
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{G}{Integer matrix of variant counts per individual, one column per individual and one row per variant.}

\item{min_ac}{Minimum allele count per individual to be considered to have a pathogenic combination of variants. '1' could correspond to a dominant inheritance hypothesis whereas '2' could correspond to a recessive inheritance hypothesis. Can either be an integer value (then used for all samples), or integer vector of \code{length(y)}, useful for example when different samples have different ploidy.}

\item{q_shape}{Beta shape hyper-priors for prior on rate of affection (i.e. being a case) amongst individuals with non-pathogenic variant combinations (i.e. they have less than \code{min_ac} variants.}

\item{p_shape}{Beta shape hyper-priors for prior on rate of affection (i.e. being a case) amongst individuals with pathogenic variant combinations (i.e. they have at least \code{min_ac} variants.}

\item{omega_shape}{Beta shape hyper-priors for prior on rate of pathogenicity amongst variants.}

\item{samples_per_chain}{Number of samples to draw from each chain.}

\item{stop_early}{Logical value determining whether to attempt to stop the sampling as soon as certain conditions are met (i.e. either the estimated marginal log likelihood lies within a certain confidence interval, or we are sufficiently confidence that the log Bayes factor against of model gamma = 1 over model gamma = 0 is sufficiently low).}

\item{blocks}{Maximum number of blocks of length \code{samples_per_chain} samples to draw before either the confidence interval for the marginal likelihood under the model gamma = 1 is sufficiently small or terminating the sampling.}

\item{burn}{Number of samples to drop from the start of the chain.}

\item{temperatures}{Numeric vector of temperatures of power posteriors. One chain will be created for each element of the vector at the corresponding temperature.}

\item{tune_temps}{Integer value - if greater than 0, the \code{temperatures} argument is ignored, and instead \code{tune_temps} tuned temperatures are used instead.}

\item{store_Z_trace}{Logical value determining whether to store the Z-vectors for each chain, which uses alot of memory, particularly if \code{samples_per_chain}, k and \code{length(temperatures)} are high.}

\item{swaps}{Number of swaps between adjacent tempered chains to perform per update cycle.}

\item{optimise_Z0}{Logical value determining whether to use a simulated annealing optimisation run to tune the initial values of \code{Z}.}

\item{tune_omega_and_phi_proposal_sd}{Logical value determining whether the proposal SDs of the Metropolis-Hastings estimated parameters should be tuned for a target acceptance range.}

\item{tune_block_size}{Integer value giving number of samples to draw when estimatating the acceptance rate of the omega/phi proposals.}

\item{variant_weights}{Vector of log-odds off-sets for rates of pathogenicity of individual variants relative to the global rate, omega.}

\item{log_phi_mean}{Mean for normal prior on scaling factor phi.}

\item{log_phi_sd}{SD for normal prior on scaling factor phi. Setting to 0 causes the weights to be fixed and not estimated.}

\item{tandem_variant_updates}{Number of tandem variant updates to make per update cycle.}

\item{...}{Other arguments to be passed to \code{\link{stop_chain}} and/or \code{\link{tune_proposal_sds}}.}
}
\value{
An object of class \code{BeviMed}.
}
\description{
This function is the main user-interface to the underlying c++ MCMC sampling routine.
}

