% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{prob_association}
\alias{prob_association}
\title{Calculate probability of an association between presence/absence of local genotype configuration and case-control label}
\usage{
prob_association(y, G, ploidy = rep(2L, length(y)), dominant_prior = 0.01,
  recessive_prior = 0.01, gamma0_shape = c(2, 100), by_MOI = FALSE, ...)
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{G}{Integer matrix of variant counts per individual, one column per individual and one row per variant.}

\item{ploidy}{Integer vector giving ploidy of samples.}

\item{dominant_prior}{Prior probability of gamma 1 model with dominant mode of inheritance.}

\item{recessive_prior}{Prior probability of gamma 1 model with recessive mode of inheritance.}

\item{gamma0_shape}{Beta shape hyper-priors for prior on rate of case labels.}

\item{by_MOI}{Logical value determining whether to return probabilities broken down by mode of inheritance.}

\item{...}{Other arguments to pass to \code{\link{log_BF}}.}
}
\value{
Probability of association.
}
\description{
Calculate probability of an association between presence/absence of local genotype configuration and case-control label
}

