% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioM2.R
\name{baseModel}
\alias{baseModel}
\title{Prediction by Machine Learning}
\usage{
baseModel(
  trainData,
  testData,
  predMode = "probability",
  classifier,
  paramlist = NULL,
  inner_folds = 10
)
}
\arguments{
\item{trainData}{The input training dataset. The first column
is the label or the output. For binary classes,
0 and 1 are used to indicate the class member.}

\item{testData}{The input test dataset. The first column
is the label or the output. For binary classes,
0 and 1 are used to indicate the class member.}

\item{predMode}{The prediction mode. Available options are
c('probability', 'classification').}

\item{classifier}{Learners in mlr3}

\item{paramlist}{Learner parameters}

\item{inner_folds}{k-fold cross validation ( Only supported when testData = NULL )}
}
\value{
The predicted output for the test data.
}
\description{
Prediction by Machine Learning with different learners ( From 'mlr3' )
}
\examples{
library(mlr3verse)
library(caret)
library(BioM2)
data=MethylData_Test
set.seed(1)
part=unlist(createDataPartition(data$label,p=0.8))#Split data
predict=baseModel(trainData=data[part,1:10],
                 testData=data[-part,1:10],
                 classifier = 'svm')#Use 10 features to make predictions,Learner uses svm


}
\author{
Shunjie Zhang
}
