% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blanket_statsments.R
\name{calculate_Uno_c}
\alias{calculate_Uno_c}
\title{Calculate Uno's C for a given model.}
\usage{
calculate_Uno_c(df, model, verbose = FALSE)
}
\arguments{
\item{df}{data.frame containing the data set. If evaluating independently, use the test set.}

\item{model}{statistical model of type coxph to be evaluated.}

\item{verbose}{logical. TRUE activates printout messages.}
}
\value{
double AUC value for the evaluated model on the specified data set.
}
\description{
Calculate Uno's concordance statistic for any model.
CAVE: If you want to evaluate a model trained on a different dataset, df should be limited to the test set.
}
\examples{
data <- survival::lung
cancer_mod <- survival::coxph(survival::Surv(time, status)~age, data = data)
calculate_Uno_c(data, cancer_mod)

}
\author{
J. Peter Marquardt
}
