% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blanket_statsments.R
\name{table_blanket_redundancies}
\alias{table_blanket_redundancies}
\title{Table results of blanket redundancy analysis}
\usage{
table_blanket_redundancies(blanket_redundancies, digits = 2)
}
\arguments{
\item{blanket_redundancies}{list of lists of redun objects generated by blanket_redundancy_analysis()}

\item{digits}{integer number of decimals to include}
}
\value{
a data.frame tabling the key results
}
\description{
Table results of a blanket redundancy analysis on a list of existing models
}
\examples{
data <- survival::lung
models_to_run <- list(
'OS' = list('outcome' = 'time', 'modality' = 'cox', 'event_censor' = 'status'),
'weight_loss' = list('outcome' = 'wt.loss', 'modality' = 'linear', 'event_censor' = NA))
predictor_sets <- list('age' = c('age'), 'age_ecog' = c('age', 'ph.ecog'))
covariates = c('sex')
bl_stats <- blanket_statsments(data, models_to_run, predictor_sets, covariates)
bl_redun <- blanket_redundancy_analysis(bl_stats, data)
table_blanket_redundancies(bl_redun)

}
\seealso{
[table_predictors()], [blanket_redundancy_analysis()]
}
\author{
J. Peter Marquardt
}
