\name{coverage}
\alias{coverage}

\title{
G-sample and goodness-of-fit tests based on empirical coverages
}
\description{
G-sample and goodness-of-fit tests based on empirical coverages (COV) are for
univariate comparisons of grouped data similar to the Kolmogorov-Smirnov family
of statistics for comparing cumulative distribution functions (Mielke and Yao 1988, 1990).
These statistics are appropriate for continuous univariate responses with no or
few tied values. Options allow for testing goodness-of-fit to a uniform distribution
on the unit circle, which is equivalent to a permutation version of Rao's spacing test (Rao 1976).
}
\usage{
coverage(variable, group, expon = 1, interv = 0, number.perms, exact = FALSE,
save.test,data)
}

\arguments{
  \item{variable}{a vector for which the coverage test is to be performed.}
  \item{group}{the (optional) vector describing the grouping structure of the variable used in the analysis.}
  \item{expon}{allows selection of alternative exponents in distance calculations.}
  \item{interv}{tells the test how many units describe the circular units of measure recorded.  This is only available for the 1-sample goodness-of-fit test.}
  \item{number.perms}{number of permutations used when not performing an exact test.  The default is 4000 permutations.}
  \item{exact}{logical indicating whether to perform an exact coverage test.  Only allowed for less than 24 observations.}
  \item{save.test}{logical indicating whether to return Monte Carlo resampled test statistic values.}
   \item{data}{the \code{data.frame} in which variable can be found.}
}
\details{
The default is to perform the test using Monte Carlo resampling.  In this case two probabilities are reported,
one which is the standard Monte Carlo approach of referencing the observed test statistic to those generated by
the resampling, and a second which uses the resampled statistics to estimate the variance and skewness of the
sampling distribution to be evaluated with the Pearson type III curve.
}
\value{
\code{coverage} returns an object of class CoverageObj.

The functions \code{\link{summary}} as well as \code{\link{print}} can be used to obtain a summary of the test.

Generic accessor functions \code{\link{pvalue}} and \code{\link{ResampVals}} can be used to obtain the p-value and Monte Carlo resampled test statistic values respectively.
}
\references{
Mielke, P.W., and Y.C. Yao. 1988. A class of multiple sample tests based on empirical coverages. \emph{Annals of the Institute of Statistical Mathematics} \bold{40}, 165--178.

Mielke, P.W. and Y.C. Yao. 1990. On g-sample empirical coverage tests: Exact and simulated null distributions of test statistics with small and moderate sample sizes. \emph{Journal Statistical Computation and Simulation} \bold{35}, 31--39.

Rao, J.S. 1976. Some tests based on arc-lengths for the circle. \emph{Sankhya}, Series B \bold{38} 329--338.
}

\seealso{
\code{\link{CoverageObj}}
}
\examples{
Out <- coverage(variable = bgrouse$distance,group = bgrouse$sex,number.perms = 10000,
save.test = TRUE)
summary(Out)
}

\keyword{nonparametric}
\keyword{htest}
