% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bolstad-package.R
\docType{data}
\name{sscsample.data}
\alias{sscsample.data}
\title{Data for simple random sampling, stratified sampling, and clusting sampling
experiments}
\format{
A data frame with 100 observations on the following 3 variables.
\itemize{ \item{income. Simulated income in $10,000}
\item{ethnicity. A numerical vector indicating the ethnic group of
the observation} \item{neighborhood. A numeric vector indicating the
neighborhood of the observation} }
}
\description{
A simulated population made up of 100 individuals. The individuals come from
three ethnic groups with population proportions of 40\%, 40\%, and 20\%,
respectively. There are twenty neighborhoods, and five individuals live in
each one.  Now, the income distribution may be different for the three
ethnic groups.  Also, individuals in the same neighborhood tend to be more
similar than individuals in different neighborhoods.
}
\examples{

data(sscsample.data)
plot(income~ethnicity, data = sscsample.data)

}
\keyword{datasets}
