% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_AutoFit.R
\name{BP_AutoFit}
\alias{BP_AutoFit}
\title{Fit model automatically}
\usage{
BP_AutoFit(
  file = file.choose(),
  xlsx = TRUE,
  rotation.angle = 0,
  center = "ontogenetic"
)
}
\arguments{
\item{file}{The file to be opened}

\item{xlsx}{TRUE, FALSE or the name and path of the report}

\item{rotation.angle}{The angle of rotation for analysis}

\item{center}{Which center to be used.}
}
\value{
Characteristics of an image with all the fit information
}
\description{
Open an image, fit a model and generate a report.
}
\details{
BP_AutoFit fits model automatically
}
\examples{
\dontrun{
# Not run:
library(BoneProfileR)
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_AutoFit(file=path_Hedgehog, xlsx=TRUE)
 # or to open a dialog box
 bone <- BP_AutoFit()
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
